
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Limited to schema subtrees that are at the level of Profile/Customer/xxxxx like PaymentForm or TPA_ProfileExtensions/xxxx like BusinessTraveler NOTE: PersonName cannot be deleted.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ModifySubtreeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PartialUpdateProfileType" name="MatchSubtree"/>
 *     &lt;xs:element type="ns:PartialUpdateIgnoreAttributesType" name="IgnoreMatchAttribute" minOccurs="0"/>
 *     &lt;xs:element type="ns:PartialUpdateProfileType" name="NewSubtree"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:PartialChildDataType" use="required" name="child"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="Y" name="MergeSubtree"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="AddIfNotFound"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ModifySubtreeType implements Serializable
{
    private PartialUpdateProfileType matchSubtree;
    private PartialUpdateIgnoreAttributesType ignoreMatchAttribute;
    private PartialUpdateProfileType newSubtree;
    private PartialChildDataType child;
    private YesNoType mergeSubtree;
    private YesNoType addIfNotFound;

    /** 
     * Get the 'MatchSubtree' element value. Requirement for min 1 instance for general case of subtrees with multiple instances. For subtrees with a single instance like VITCustomer matching data not required.  If no match found for criteria then NewSubtree data is created
     * 
     * @return value
     */
    public PartialUpdateProfileType getMatchSubtree() {
        return matchSubtree;
    }

    /** 
     * Set the 'MatchSubtree' element value. Requirement for min 1 instance for general case of subtrees with multiple instances. For subtrees with a single instance like VITCustomer matching data not required.  If no match found for criteria then NewSubtree data is created
     * 
     * @param matchSubtree
     */
    public void setMatchSubtree(PartialUpdateProfileType matchSubtree) {
        this.matchSubtree = matchSubtree;
    }

    /** 
     * Get the 'IgnoreMatchAttribute' element value. Attributes that will be ignored during element matching
     * 
     * @return value
     */
    public PartialUpdateIgnoreAttributesType getIgnoreMatchAttribute() {
        return ignoreMatchAttribute;
    }

    /** 
     * Set the 'IgnoreMatchAttribute' element value. Attributes that will be ignored during element matching
     * 
     * @param ignoreMatchAttribute
     */
    public void setIgnoreMatchAttribute(
            PartialUpdateIgnoreAttributesType ignoreMatchAttribute) {
        this.ignoreMatchAttribute = ignoreMatchAttribute;
    }

    /** 
     * Get the 'NewSubtree' element value. Requires as much data as the view of the client has
     * 
     * @return value
     */
    public PartialUpdateProfileType getNewSubtree() {
        return newSubtree;
    }

    /** 
     * Set the 'NewSubtree' element value. Requires as much data as the view of the client has
     * 
     * @param newSubtree
     */
    public void setNewSubtree(PartialUpdateProfileType newSubtree) {
        this.newSubtree = newSubtree;
    }

    /** 
     * Get the 'child' attribute value.
     * 
     * @return value
     */
    public PartialChildDataType getChild() {
        return child;
    }

    /** 
     * Set the 'child' attribute value.
     * 
     * @param child
     */
    public void setChild(PartialChildDataType child) {
        this.child = child;
    }

    /** 
     * Get the 'MergeSubtree' attribute value.
     * 
     * @return value
     */
    public YesNoType getMergeSubtree() {
        return mergeSubtree;
    }

    /** 
     * Set the 'MergeSubtree' attribute value.
     * 
     * @param mergeSubtree
     */
    public void setMergeSubtree(YesNoType mergeSubtree) {
        this.mergeSubtree = mergeSubtree;
    }

    /** 
     * Get the 'AddIfNotFound' attribute value.
     * 
     * @return value
     */
    public YesNoType getAddIfNotFound() {
        return addIfNotFound;
    }

    /** 
     * Set the 'AddIfNotFound' attribute value.
     * 
     * @param addIfNotFound
     */
    public void setAddIfNotFound(YesNoType addIfNotFound) {
        this.addIfNotFound = addIfNotFound;
    }
}
