
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * When Copy/Move Profiles/Templates across PCC with branch access only associated TO data is copied
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MoveToDomainRSType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:MoveDomainObjectRSType" name="Moved" minOccurs="0"/>
 *     &lt;xs:element type="ns:MoveDomainObjectRSType" name="Copied" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="OriginDomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DestinationDomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MoveToDomainRSType implements Serializable
{
    private MoveDomainObjectRSType moved;
    private MoveDomainObjectRSType copied;
    private String originDomainID;
    private String destinationDomainID;
    private String clientCode;
    private String clientContextCode;

    /** 
     * Get the 'Moved' element value.
     * 
     * @return value
     */
    public MoveDomainObjectRSType getMoved() {
        return moved;
    }

    /** 
     * Set the 'Moved' element value.
     * 
     * @param moved
     */
    public void setMoved(MoveDomainObjectRSType moved) {
        this.moved = moved;
    }

    /** 
     * Get the 'Copied' element value.
     * 
     * @return value
     */
    public MoveDomainObjectRSType getCopied() {
        return copied;
    }

    /** 
     * Set the 'Copied' element value.
     * 
     * @param copied
     */
    public void setCopied(MoveDomainObjectRSType copied) {
        this.copied = copied;
    }

    /** 
     * Get the 'OriginDomainID' attribute value. DomainID from which data will be moved
     * 
     * @return value
     */
    public String getOriginDomainID() {
        return originDomainID;
    }

    /** 
     * Set the 'OriginDomainID' attribute value. DomainID from which data will be moved
     * 
     * @param originDomainID
     */
    public void setOriginDomainID(String originDomainID) {
        this.originDomainID = originDomainID;
    }

    /** 
     * Get the 'DestinationDomainID' attribute value. DomainID to which data will be moved. Should be different from origin
     * 
     * @return value
     */
    public String getDestinationDomainID() {
        return destinationDomainID;
    }

    /** 
     * Set the 'DestinationDomainID' attribute value. DomainID to which data will be moved. Should be different from origin
     * 
     * @param destinationDomainID
     */
    public void setDestinationDomainID(String destinationDomainID) {
        this.destinationDomainID = destinationDomainID;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }
}
