
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * When Copy/Move Profiles/Templates across PCC with branch access only associated TO data is copied
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MoveToDomainType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:TPAIdentityType" name="Profile"/>
 *     &lt;xs:element type="ns:TemplateIdentityType" name="Template"/>
 *     &lt;xs:element type="ns:MetadataIdentityType" name="Metadata"/>
 *     &lt;xs:element type="ns:ValidatorIdentityType" name="Validator"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="xs:string" use="required" name="DestinationDomainID"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="IgnoreAssociations"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MoveToDomainType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PROFILE_CHOICE = 0;
    private static final int TEMPLATE_CHOICE = 1;
    private static final int METADATA_CHOICE = 2;
    private static final int VALIDATOR_CHOICE = 3;
    private TPAIdentityType profile;
    private TemplateIdentityType template;
    private MetadataIdentityType metadata;
    private ValidatorIdentityType validator;
    private String destinationDomainID;
    private YesNoType ignoreAssociations;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Profile is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfile() {
        return choiceSelect == PROFILE_CHOICE;
    }

    /** 
     * Get the 'Profile' element value. Profile to be moved
     * 
     * @return value
     */
    public TPAIdentityType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value. Profile to be moved
     * 
     * @param profile
     */
    public void setProfile(TPAIdentityType profile) {
        setChoiceSelect(PROFILE_CHOICE);
        this.profile = profile;
    }

    /** 
     * Check if Template is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTemplate() {
        return choiceSelect == TEMPLATE_CHOICE;
    }

    /** 
     * Get the 'Template' element value. Template to be moved
     * 
     * @return value
     */
    public TemplateIdentityType getTemplate() {
        return template;
    }

    /** 
     * Set the 'Template' element value. Template to be moved
     * 
     * @param template
     */
    public void setTemplate(TemplateIdentityType template) {
        setChoiceSelect(TEMPLATE_CHOICE);
        this.template = template;
    }

    /** 
     * Check if Metadata is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMetadata() {
        return choiceSelect == METADATA_CHOICE;
    }

    /** 
     * Get the 'Metadata' element value. Metadata to be moved
     * 
     * @return value
     */
    public MetadataIdentityType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata to be moved
     * 
     * @param metadata
     */
    public void setMetadata(MetadataIdentityType metadata) {
        setChoiceSelect(METADATA_CHOICE);
        this.metadata = metadata;
    }

    /** 
     * Check if Validator is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifValidator() {
        return choiceSelect == VALIDATOR_CHOICE;
    }

    /** 
     * Get the 'Validator' element value. Validator to be moved
     * 
     * @return value
     */
    public ValidatorIdentityType getValidator() {
        return validator;
    }

    /** 
     * Set the 'Validator' element value. Validator to be moved
     * 
     * @param validator
     */
    public void setValidator(ValidatorIdentityType validator) {
        setChoiceSelect(VALIDATOR_CHOICE);
        this.validator = validator;
    }

    /** 
     * Get the 'DestinationDomainID' attribute value. DomainID to which profile or template will be moved or copied
     * 
     * @return value
     */
    public String getDestinationDomainID() {
        return destinationDomainID;
    }

    /** 
     * Set the 'DestinationDomainID' attribute value. DomainID to which profile or template will be moved or copied
     * 
     * @param destinationDomainID
     */
    public void setDestinationDomainID(String destinationDomainID) {
        this.destinationDomainID = destinationDomainID;
    }

    /** 
     * Get the 'IgnoreAssociations' attribute value. Moves element without associations if Yes value is specified
     * 
     * @return value
     */
    public YesNoType getIgnoreAssociations() {
        return ignoreAssociations;
    }

    /** 
     * Set the 'IgnoreAssociations' attribute value. Moves element without associations if Yes value is specified
     * 
     * @param ignoreAssociations
     */
    public void setIgnoreAssociations(YesNoType ignoreAssociations) {
        this.ignoreAssociations = ignoreAssociations;
    }
}
