
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Identifies a collection of preferences for airline travel.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartialAirlinePrefType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:AirportPrefType" name="AirportPref" minOccurs="0"/>
 *     &lt;xs:element type="ns:AirlineSeatPrefType" name="AirlineSeatPref" minOccurs="0"/>
 *     &lt;xs:element type="ns:AirlineCabinPrefType" name="AirlineCabinPref" minOccurs="0"/>
 *     &lt;xs:element type="ns:AirlineMealPrefType" name="AirlineMealPref" minOccurs="0"/>
 *     &lt;xs:element type="ns:AirlineUpgradePrefType" name="AirlineUpgradePref" minOccurs="0"/>
 *     &lt;xs:element type="ns:PreferredAirlinesType" name="PreferredAirlines" minOccurs="0"/>
 *     &lt;xs:element type="ns:PreferredAggregatorType" name="PreferredAggregator" minOccurs="0"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="xs:string" use="required" name="TripTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoRegionCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoDestinationCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoOriginCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PartialAirlinePrefType implements Serializable
{
    private int choiceSelect = -1;
    private static final int AIRPORT_PREF_CHOICE = 0;
    private static final int AIRLINE_SEAT_PREF_CHOICE = 1;
    private static final int AIRLINE_CABIN_PREF_CHOICE = 2;
    private static final int AIRLINE_MEAL_PREF_CHOICE = 3;
    private static final int AIRLINE_UPGRADE_PREF_CHOICE = 4;
    private static final int PREFERRED_AIRLINES_CHOICE = 5;
    private static final int PREFERRED_AGGREGATOR_CHOICE = 6;
    private AirportPrefType airportPref;
    private AirlineSeatPrefType airlineSeatPref;
    private AirlineCabinPrefType airlineCabinPref;
    private AirlineMealPrefType airlineMealPref;
    private AirlineUpgradePrefType airlineUpgradePref;
    private PreferredAirlinesType preferredAirlines;
    private PreferredAggregatorType preferredAggregator;
    private String tripTypeCode;
    private String informationText;
    private String geoRegionCode;
    private String geoDestinationCode;
    private String geoOriginCode;
    private String displaySequenceNo;
    private String orderSequenceNo;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AirportPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirportPref() {
        return choiceSelect == AIRPORT_PREF_CHOICE;
    }

    /** 
     * Get the 'AirportPref' element value. ***OTA Based ***  Identifies the preferred origination airport for travel (using IATA airport codes).
     * 
     * @return value
     */
    public AirportPrefType getAirportPref() {
        return airportPref;
    }

    /** 
     * Set the 'AirportPref' element value. ***OTA Based ***  Identifies the preferred origination airport for travel (using IATA airport codes).
     * 
     * @param airportPref
     */
    public void setAirportPref(AirportPrefType airportPref) {
        setChoiceSelect(AIRPORT_PREF_CHOICE);
        this.airportPref = airportPref;
    }

    /** 
     * Check if AirlineSeatPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirlineSeatPref() {
        return choiceSelect == AIRLINE_SEAT_PREF_CHOICE;
    }

    /** 
     * Get the 'AirlineSeatPref' element value.  ***OTA Based *** Indicates preferred seat characteristics.  Refer to OTA Code List Seat Preference (STP) for codes.
     * 
     * @return value
     */
    public AirlineSeatPrefType getAirlineSeatPref() {
        return airlineSeatPref;
    }

    /** 
     * Set the 'AirlineSeatPref' element value.  ***OTA Based *** Indicates preferred seat characteristics.  Refer to OTA Code List Seat Preference (STP) for codes.
     * 
     * @param airlineSeatPref
     */
    public void setAirlineSeatPref(AirlineSeatPrefType airlineSeatPref) {
        setChoiceSelect(AIRLINE_SEAT_PREF_CHOICE);
        this.airlineSeatPref = airlineSeatPref;
    }

    /** 
     * Check if AirlineCabinPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirlineCabinPref() {
        return choiceSelect == AIRLINE_CABIN_PREF_CHOICE;
    }

    /** 
     * Get the 'AirlineCabinPref' element value.  ***OTA Based *** Indicates preferred Cabins 
     * 
     * @return value
     */
    public AirlineCabinPrefType getAirlineCabinPref() {
        return airlineCabinPref;
    }

    /** 
     * Set the 'AirlineCabinPref' element value.  ***OTA Based *** Indicates preferred Cabins 
     * 
     * @param airlineCabinPref
     */
    public void setAirlineCabinPref(AirlineCabinPrefType airlineCabinPref) {
        setChoiceSelect(AIRLINE_CABIN_PREF_CHOICE);
        this.airlineCabinPref = airlineCabinPref;
    }

    /** 
     * Check if AirlineMealPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirlineMealPref() {
        return choiceSelect == AIRLINE_MEAL_PREF_CHOICE;
    }

    /** 
     * Get the 'AirlineMealPref' element value. ***OTA Based *** Indicates preferred meal type (e.g., vegetarian, Kosher, low fat)
     * 
     * @return value
     */
    public AirlineMealPrefType getAirlineMealPref() {
        return airlineMealPref;
    }

    /** 
     * Set the 'AirlineMealPref' element value. ***OTA Based *** Indicates preferred meal type (e.g., vegetarian, Kosher, low fat)
     * 
     * @param airlineMealPref
     */
    public void setAirlineMealPref(AirlineMealPrefType airlineMealPref) {
        setChoiceSelect(AIRLINE_MEAL_PREF_CHOICE);
        this.airlineMealPref = airlineMealPref;
    }

    /** 
     * Check if AirlineUpgradePref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirlineUpgradePref() {
        return choiceSelect == AIRLINE_UPGRADE_PREF_CHOICE;
    }

    /** 
     * Get the 'AirlineUpgradePref' element value. ***OTA Based *** Indicates Upgrade Preferecnes for Airlines
     * 
     * @return value
     */
    public AirlineUpgradePrefType getAirlineUpgradePref() {
        return airlineUpgradePref;
    }

    /** 
     * Set the 'AirlineUpgradePref' element value. ***OTA Based *** Indicates Upgrade Preferecnes for Airlines
     * 
     * @param airlineUpgradePref
     */
    public void setAirlineUpgradePref(AirlineUpgradePrefType airlineUpgradePref) {
        setChoiceSelect(AIRLINE_UPGRADE_PREF_CHOICE);
        this.airlineUpgradePref = airlineUpgradePref;
    }

    /** 
     * Check if PreferredAirlines is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPreferredAirlines() {
        return choiceSelect == PREFERRED_AIRLINES_CHOICE;
    }

    /** 
     * Get the 'PreferredAirlines' element value. ***SABRE ADDED*** Stores List of Preferred and excluded Vendors
     * 
     * @return value
     */
    public PreferredAirlinesType getPreferredAirlines() {
        return preferredAirlines;
    }

    /** 
     * Set the 'PreferredAirlines' element value. ***SABRE ADDED*** Stores List of Preferred and excluded Vendors
     * 
     * @param preferredAirlines
     */
    public void setPreferredAirlines(PreferredAirlinesType preferredAirlines) {
        setChoiceSelect(PREFERRED_AIRLINES_CHOICE);
        this.preferredAirlines = preferredAirlines;
    }

    /** 
     * Check if PreferredAggregator is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPreferredAggregator() {
        return choiceSelect == PREFERRED_AGGREGATOR_CHOICE;
    }

    /** 
     * Get the 'PreferredAggregator' element value. ***SABRE ADDED*** Stores List of Preferred and excluded Aggregators
     * 
     * @return value
     */
    public PreferredAggregatorType getPreferredAggregator() {
        return preferredAggregator;
    }

    /** 
     * Set the 'PreferredAggregator' element value. ***SABRE ADDED*** Stores List of Preferred and excluded Aggregators
     * 
     * @param preferredAggregator
     */
    public void setPreferredAggregator(
            PreferredAggregatorType preferredAggregator) {
        setChoiceSelect(PREFERRED_AGGREGATOR_CHOICE);
        this.preferredAggregator = preferredAggregator;
    }

    /** 
     * Get the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getTripTypeCode() {
        return tripTypeCode;
    }

    /** 
     * Set the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @param tripTypeCode
     */
    public void setTripTypeCode(String tripTypeCode) {
        this.tripTypeCode = tripTypeCode;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'GeoRegionCode' attribute value. Region type Code	
     * 
     * @return value
     */
    public String getGeoRegionCode() {
        return geoRegionCode;
    }

    /** 
     * Set the 'GeoRegionCode' attribute value. Region type Code	
     * 
     * @param geoRegionCode
     */
    public void setGeoRegionCode(String geoRegionCode) {
        this.geoRegionCode = geoRegionCode;
    }

    /** 
     * Get the 'GeoDestinationCode' attribute value. Des type Code	
     * 
     * @return value
     */
    public String getGeoDestinationCode() {
        return geoDestinationCode;
    }

    /** 
     * Set the 'GeoDestinationCode' attribute value. Des type Code	
     * 
     * @param geoDestinationCode
     */
    public void setGeoDestinationCode(String geoDestinationCode) {
        this.geoDestinationCode = geoDestinationCode;
    }

    /** 
     * Get the 'GeoOriginCode' attribute value. Origin Code	
     * 
     * @return value
     */
    public String getGeoOriginCode() {
        return geoOriginCode;
    }

    /** 
     * Set the 'GeoOriginCode' attribute value. Origin Code	
     * 
     * @param geoOriginCode
     */
    public void setGeoOriginCode(String geoOriginCode) {
        this.geoOriginCode = geoOriginCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value.
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value.
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }
}
