
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * These are the hotel preference elements used on an instance of a profile.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartialHotelPrefType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:PreferredHotelType" name="PreferredHotel" minOccurs="0"/>
 *     &lt;xs:element type="ns:PreferredAggregatorType" name="PreferredAggregator" minOccurs="0"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="xs:string" name="TripTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoOriginCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoDestinationCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoRegionCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PartialHotelPrefType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PREFERRED_HOTEL_CHOICE = 0;
    private static final int PREFERRED_AGGREGATOR_CHOICE = 1;
    private PreferredHotelType preferredHotel;
    private PreferredAggregatorType preferredAggregator;
    private String tripTypeCode;
    private String geoOriginCode;
    private String geoDestinationCode;
    private String geoRegionCode;
    private String informationText;
    private String orderSequenceNo;
    private String displaySequenceNo;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if PreferredHotel is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPreferredHotel() {
        return choiceSelect == PREFERRED_HOTEL_CHOICE;
    }

    /** 
     * Get the 'PreferredHotel' element value. ***SABRE ADDED*** Stores List of Preferred and excluded Vendors
     * 
     * @return value
     */
    public PreferredHotelType getPreferredHotel() {
        return preferredHotel;
    }

    /** 
     * Set the 'PreferredHotel' element value. ***SABRE ADDED*** Stores List of Preferred and excluded Vendors
     * 
     * @param preferredHotel
     */
    public void setPreferredHotel(PreferredHotelType preferredHotel) {
        setChoiceSelect(PREFERRED_HOTEL_CHOICE);
        this.preferredHotel = preferredHotel;
    }

    /** 
     * Check if PreferredAggregator is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPreferredAggregator() {
        return choiceSelect == PREFERRED_AGGREGATOR_CHOICE;
    }

    /** 
     * Get the 'PreferredAggregator' element value. ***SABRE ADDED*** Stores List of Preferred and excluded Aggregators
     * 
     * @return value
     */
    public PreferredAggregatorType getPreferredAggregator() {
        return preferredAggregator;
    }

    /** 
     * Set the 'PreferredAggregator' element value. ***SABRE ADDED*** Stores List of Preferred and excluded Aggregators
     * 
     * @param preferredAggregator
     */
    public void setPreferredAggregator(
            PreferredAggregatorType preferredAggregator) {
        setChoiceSelect(PREFERRED_AGGREGATOR_CHOICE);
        this.preferredAggregator = preferredAggregator;
    }

    /** 
     * Get the 'TripTypeCode' attribute value. Trip type Code
     * 
     * @return value
     */
    public String getTripTypeCode() {
        return tripTypeCode;
    }

    /** 
     * Set the 'TripTypeCode' attribute value. Trip type Code
     * 
     * @param tripTypeCode
     */
    public void setTripTypeCode(String tripTypeCode) {
        this.tripTypeCode = tripTypeCode;
    }

    /** 
     * Get the 'GeoOriginCode' attribute value. Origin Code
     * 
     * @return value
     */
    public String getGeoOriginCode() {
        return geoOriginCode;
    }

    /** 
     * Set the 'GeoOriginCode' attribute value. Origin Code
     * 
     * @param geoOriginCode
     */
    public void setGeoOriginCode(String geoOriginCode) {
        this.geoOriginCode = geoOriginCode;
    }

    /** 
     * Get the 'GeoDestinationCode' attribute value. Des type Code
     * 
     * @return value
     */
    public String getGeoDestinationCode() {
        return geoDestinationCode;
    }

    /** 
     * Set the 'GeoDestinationCode' attribute value. Des type Code
     * 
     * @param geoDestinationCode
     */
    public void setGeoDestinationCode(String geoDestinationCode) {
        this.geoDestinationCode = geoDestinationCode;
    }

    /** 
     * Get the 'GeoRegionCode' attribute value. Region type Code
     * 
     * @return value
     */
    public String getGeoRegionCode() {
        return geoRegionCode;
    }

    /** 
     * Set the 'GeoRegionCode' attribute value. Region type Code
     * 
     * @param geoRegionCode
     */
    public void setGeoRegionCode(String geoRegionCode) {
        this.geoRegionCode = geoRegionCode;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value.
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value.
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }
}
