
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartialUpdateDictionaryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DictionaryIdentityType" name="DictionaryIdentity"/>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:DictionaryAdditionsType" name="Additions"/>
 *       &lt;xs:element type="ns:DictionaryDeletionsType" name="Deletions"/>
 *       &lt;xs:element type="ns:DictionaryModificationsType" name="Modifications"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PartialUpdateDictionaryType implements Serializable
{
    private DictionaryIdentityType dictionaryIdentity;
    private int choiceSelect = -1;
    private static final int ADDITIONS_CHOICE = 0;
    private static final int DELETIONS_CHOICE = 1;
    private static final int MODIFICATIONS_CHOICE = 2;
    private DictionaryAdditionsType additions;
    private DictionaryDeletionsType deletions;
    private DictionaryModificationsType modifications;

    /** 
     * Get the 'DictionaryIdentity' element value.
     * 
     * @return value
     */
    public DictionaryIdentityType getDictionaryIdentity() {
        return dictionaryIdentity;
    }

    /** 
     * Set the 'DictionaryIdentity' element value.
     * 
     * @param dictionaryIdentity
     */
    public void setDictionaryIdentity(DictionaryIdentityType dictionaryIdentity) {
        this.dictionaryIdentity = dictionaryIdentity;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Additions is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAdditions() {
        return choiceSelect == ADDITIONS_CHOICE;
    }

    /** 
     * Get the 'Additions' element value.
     * 
     * @return value
     */
    public DictionaryAdditionsType getAdditions() {
        return additions;
    }

    /** 
     * Set the 'Additions' element value.
     * 
     * @param additions
     */
    public void setAdditions(DictionaryAdditionsType additions) {
        setChoiceSelect(ADDITIONS_CHOICE);
        this.additions = additions;
    }

    /** 
     * Check if Deletions is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDeletions() {
        return choiceSelect == DELETIONS_CHOICE;
    }

    /** 
     * Get the 'Deletions' element value.
     * 
     * @return value
     */
    public DictionaryDeletionsType getDeletions() {
        return deletions;
    }

    /** 
     * Set the 'Deletions' element value.
     * 
     * @param deletions
     */
    public void setDeletions(DictionaryDeletionsType deletions) {
        setChoiceSelect(DELETIONS_CHOICE);
        this.deletions = deletions;
    }

    /** 
     * Check if Modifications is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifModifications() {
        return choiceSelect == MODIFICATIONS_CHOICE;
    }

    /** 
     * Get the 'Modifications' element value.
     * 
     * @return value
     */
    public DictionaryModificationsType getModifications() {
        return modifications;
    }

    /** 
     * Set the 'Modifications' element value.
     * 
     * @param modifications
     */
    public void setModifications(DictionaryModificationsType modifications) {
        setChoiceSelect(MODIFICATIONS_CHOICE);
        this.modifications = modifications;
    }
}
