
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartialUpdateProfileType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:PartialUpdateTravelerProfileType" name="Traveler"/>
 *     &lt;xs:element type="ns:PartialUpdateSabreTravelPolicyType" name="SabreTravelPolicy"/>
 *     &lt;xs:element type="ns:PaymentFormType" name="PaymentForm"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PartialUpdateProfileType implements Serializable
{
    private int choiceSelect = -1;
    private static final int TRAVELER_CHOICE = 0;
    private static final int SABRE_TRAVEL_POLICY_CHOICE = 1;
    private static final int PAYMENT_FORM_CHOICE = 2;
    private PartialUpdateTravelerProfileType traveler;
    private PartialUpdateSabreTravelPolicyType sabreTravelPolicy;
    private PaymentFormType paymentForm;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Traveler is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTraveler() {
        return choiceSelect == TRAVELER_CHOICE;
    }

    /** 
     * Get the 'Traveler' element value. *** SABRE ADDED *** Partial Update Traveler profile content.
     * 
     * @return value
     */
    public PartialUpdateTravelerProfileType getTraveler() {
        return traveler;
    }

    /** 
     * Set the 'Traveler' element value. *** SABRE ADDED *** Partial Update Traveler profile content.
     * 
     * @param traveler
     */
    public void setTraveler(PartialUpdateTravelerProfileType traveler) {
        setChoiceSelect(TRAVELER_CHOICE);
        this.traveler = traveler;
    }

    /** 
     * Check if SabreTravelPolicy is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSabreTravelPolicy() {
        return choiceSelect == SABRE_TRAVEL_POLICY_CHOICE;
    }

    /** 
     * Get the 'SabreTravelPolicy' element value. *** SABRE ADDED *** Sabre New Travel Policy Policies Information 
     * 
     * @return value
     */
    public PartialUpdateSabreTravelPolicyType getSabreTravelPolicy() {
        return sabreTravelPolicy;
    }

    /** 
     * Set the 'SabreTravelPolicy' element value. *** SABRE ADDED *** Sabre New Travel Policy Policies Information 
     * 
     * @param sabreTravelPolicy
     */
    public void setSabreTravelPolicy(
            PartialUpdateSabreTravelPolicyType sabreTravelPolicy) {
        setChoiceSelect(SABRE_TRAVEL_POLICY_CHOICE);
        this.sabreTravelPolicy = sabreTravelPolicy;
    }

    /** 
     * Check if PaymentForm is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPaymentForm() {
        return choiceSelect == PAYMENT_FORM_CHOICE;
    }

    /** 
     * Get the 'PaymentForm' element value.
     * 
     * @return value
     */
    public PaymentFormType getPaymentForm() {
        return paymentForm;
    }

    /** 
     * Set the 'PaymentForm' element value.
     * 
     * @param paymentForm
     */
    public void setPaymentForm(PaymentFormType paymentForm) {
        setChoiceSelect(PAYMENT_FORM_CHOICE);
        this.paymentForm = paymentForm;
    }
}
