
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Root element for partial Traveler profile content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartialUpdateTravelerProfileType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:PersonNameType" name="PersonName"/>
 *     &lt;xs:element type="ns:TelephoneType" name="Telephone"/>
 *     &lt;xs:element type="ns:EmailType" name="Email"/>
 *     &lt;xs:element type="ns:AddressType" name="Address"/>
 *     &lt;xs:element type="ns:PaymentFormType" name="PaymentForm"/>
 *     &lt;xs:element type="ns:RelatedIndividualType" name="RelatedIndividual"/>
 *     &lt;xs:element type="ns:ContactType" name="EmergencyContactPerson"/>
 *     &lt;xs:element type="ns:DocumentType" name="Document"/>
 *     &lt;xs:element type="ns:CustLoyaltyType" name="CustLoyalty"/>
 *     &lt;xs:element type="ns:EmploymentInfoType" name="EmploymentInfo"/>
 *     &lt;xs:element type="ns:PartialAirlinePrefType" name="AirlinePref"/>
 *     &lt;xs:element type="ns:PartialHotelPrefType" name="HotelPref"/>
 *     &lt;xs:element type="ns:PartialVehicleRentalPrefType" name="VehicleRentalPref"/>
 *     &lt;xs:element type="ns:PartialLoungePrefType" name="LoungePref"/>
 *     &lt;xs:element type="ns:NotificationPreferenceType" name="NotificationPreference"/>
 *     &lt;xs:element type="ns:ConsentType" name="Consent"/>
 *     &lt;xs:element type="ns:PsychographicCategoryType" name="PsychographicCategory"/>
 *     &lt;xs:element type="ns:PriorityRemarksType" name="PriorityRemarks"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark"/>
 *     &lt;xs:element type="ns:SSRType" name="SSR"/>
 *     &lt;xs:element type="ns:CustomerReferenceInfoType" name="CustomerReferenceInfo"/>
 *     &lt;xs:element type="ns:AssociatedProfilesType" name="AssociatedProfiles"/>
 *     &lt;xs:element type="ns:AssociatedFiltersType" name="AssociatedFilters"/>
 *     &lt;xs:element type="ns:AssociatedTemplateType" name="AssociatedTemplate"/>
 *     &lt;xs:element type="ns:CustomDefinedDataType" name="CustomDefinedData"/>
 *     &lt;xs:element type="ns:CustomerValueScoreType" name="CustomerValueScore"/>
 *     &lt;xs:element type="ns:LoginType" name="Login"/>
 *     &lt;xs:element type="ns:SecurityInfoType" name="SecurityInfo"/>
 *     &lt;xs:element type="ns:ProfileSubTypeType" name="ProfileSubType"/>
 *     &lt;xs:element type="ns:OSIType" name="OSI"/>
 *     &lt;xs:element type="ns:DiscountsType" name="Discounts"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PartialUpdateTravelerProfileType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PERSON_NAME_CHOICE = 0;
    private static final int TELEPHONE_CHOICE = 1;
    private static final int EMAIL_CHOICE = 2;
    private static final int ADDRESS_CHOICE = 3;
    private static final int PAYMENT_FORM_CHOICE = 4;
    private static final int RELATED_INDIVIDUAL_CHOICE = 5;
    private static final int EMERGENCY_CONTACT_PERSON_CHOICE = 6;
    private static final int DOCUMENT_CHOICE = 7;
    private static final int CUST_LOYALTY_CHOICE = 8;
    private static final int EMPLOYMENT_INFO_CHOICE = 9;
    private static final int AIRLINE_PREF_CHOICE = 10;
    private static final int HOTEL_PREF_CHOICE = 11;
    private static final int VEHICLE_RENTAL_PREF_CHOICE = 12;
    private static final int LOUNGE_PREF_CHOICE = 13;
    private static final int NOTIFICATION_PREFERENCE_CHOICE = 14;
    private static final int CONSENT_CHOICE = 15;
    private static final int PSYCHOGRAPHIC_CATEGORY_CHOICE = 16;
    private static final int PRIORITY_REMARKS_CHOICE = 17;
    private static final int REMARK_CHOICE = 18;
    private static final int SSR_CHOICE = 19;
    private static final int CUSTOMER_REFERENCE_INFO_CHOICE = 20;
    private static final int ASSOCIATED_PROFILES_CHOICE = 21;
    private static final int ASSOCIATED_FILTERS_CHOICE = 22;
    private static final int ASSOCIATED_TEMPLATE_CHOICE = 23;
    private static final int CUSTOM_DEFINED_DATA_CHOICE = 24;
    private static final int CUSTOMER_VALUE_SCORE_CHOICE = 25;
    private static final int LOGIN_CHOICE = 26;
    private static final int SECURITY_INFO_CHOICE = 27;
    private static final int PROFILE_SUB_TYPE_CHOICE = 28;
    private static final int OSI_CHOICE = 29;
    private static final int DISCOUNTS_CHOICE = 30;
    private PersonNameType personName;
    private TelephoneType telephone;
    private EmailType email;
    private AddressType address;
    private PaymentFormType paymentForm;
    private RelatedIndividualType relatedIndividual;
    private ContactType emergencyContactPerson;
    private DocumentType document;
    private CustLoyaltyType custLoyalty;
    private EmploymentInfoType employmentInfo;
    private PartialAirlinePrefType airlinePref;
    private PartialHotelPrefType hotelPref;
    private PartialVehicleRentalPrefType vehicleRentalPref;
    private PartialLoungePrefType loungePref;
    private NotificationPreferenceType notificationPreference;
    private ConsentType consent;
    private PsychographicCategoryType psychographicCategory;
    private PriorityRemarksType priorityRemarks;
    private RemarkType remark;
    private SSRType SSR;
    private CustomerReferenceInfoType customerReferenceInfo;
    private AssociatedProfilesType associatedProfiles;
    private AssociatedFiltersType associatedFilters;
    private AssociatedTemplateType associatedTemplate;
    private CustomDefinedDataType customDefinedData;
    private CustomerValueScoreType customerValueScore;
    private LoginType login;
    private SecurityInfoType securityInfo;
    private ProfileSubTypeType profileSubType;
    private OSIType OSI;
    private DiscountsType discounts;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if PersonName is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPersonName() {
        return choiceSelect == PERSON_NAME_CHOICE;
    }

    /** 
     * Get the 'PersonName' element value.
     * 
     * @return value
     */
    public PersonNameType getPersonName() {
        return personName;
    }

    /** 
     * Set the 'PersonName' element value.
     * 
     * @param personName
     */
    public void setPersonName(PersonNameType personName) {
        setChoiceSelect(PERSON_NAME_CHOICE);
        this.personName = personName;
    }

    /** 
     * Check if Telephone is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTelephone() {
        return choiceSelect == TELEPHONE_CHOICE;
    }

    /** 
     * Get the 'Telephone' element value.
     * 
     * @return value
     */
    public TelephoneType getTelephone() {
        return telephone;
    }

    /** 
     * Set the 'Telephone' element value.
     * 
     * @param telephone
     */
    public void setTelephone(TelephoneType telephone) {
        setChoiceSelect(TELEPHONE_CHOICE);
        this.telephone = telephone;
    }

    /** 
     * Check if Email is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmail() {
        return choiceSelect == EMAIL_CHOICE;
    }

    /** 
     * Get the 'Email' element value.
     * 
     * @return value
     */
    public EmailType getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value.
     * 
     * @param email
     */
    public void setEmail(EmailType email) {
        setChoiceSelect(EMAIL_CHOICE);
        this.email = email;
    }

    /** 
     * Check if Address is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAddress() {
        return choiceSelect == ADDRESS_CHOICE;
    }

    /** 
     * Get the 'Address' element value.
     * 
     * @return value
     */
    public AddressType getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value.
     * 
     * @param address
     */
    public void setAddress(AddressType address) {
        setChoiceSelect(ADDRESS_CHOICE);
        this.address = address;
    }

    /** 
     * Check if PaymentForm is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPaymentForm() {
        return choiceSelect == PAYMENT_FORM_CHOICE;
    }

    /** 
     * Get the 'PaymentForm' element value. *** Deprecated *** please use //element(*,PartialUpdateProfileType)/PaymentForm
     * 
     * @return value
     */
    public PaymentFormType getPaymentForm() {
        return paymentForm;
    }

    /** 
     * Set the 'PaymentForm' element value. *** Deprecated *** please use //element(*,PartialUpdateProfileType)/PaymentForm
     * 
     * @param paymentForm
     */
    public void setPaymentForm(PaymentFormType paymentForm) {
        setChoiceSelect(PAYMENT_FORM_CHOICE);
        this.paymentForm = paymentForm;
    }

    /** 
     * Check if RelatedIndividual is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRelatedIndividual() {
        return choiceSelect == RELATED_INDIVIDUAL_CHOICE;
    }

    /** 
     * Get the 'RelatedIndividual' element value.
     * 
     * @return value
     */
    public RelatedIndividualType getRelatedIndividual() {
        return relatedIndividual;
    }

    /** 
     * Set the 'RelatedIndividual' element value.
     * 
     * @param relatedIndividual
     */
    public void setRelatedIndividual(RelatedIndividualType relatedIndividual) {
        setChoiceSelect(RELATED_INDIVIDUAL_CHOICE);
        this.relatedIndividual = relatedIndividual;
    }

    /** 
     * Check if EmergencyContactPerson is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmergencyContactPerson() {
        return choiceSelect == EMERGENCY_CONTACT_PERSON_CHOICE;
    }

    /** 
     * Get the 'EmergencyContactPerson' element value.
     * 
     * @return value
     */
    public ContactType getEmergencyContactPerson() {
        return emergencyContactPerson;
    }

    /** 
     * Set the 'EmergencyContactPerson' element value.
     * 
     * @param emergencyContactPerson
     */
    public void setEmergencyContactPerson(ContactType emergencyContactPerson) {
        setChoiceSelect(EMERGENCY_CONTACT_PERSON_CHOICE);
        this.emergencyContactPerson = emergencyContactPerson;
    }

    /** 
     * Check if Document is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDocument() {
        return choiceSelect == DOCUMENT_CHOICE;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public DocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(DocumentType document) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.document = document;
    }

    /** 
     * Check if CustLoyalty is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustLoyalty() {
        return choiceSelect == CUST_LOYALTY_CHOICE;
    }

    /** 
     * Get the 'CustLoyalty' element value.
     * 
     * @return value
     */
    public CustLoyaltyType getCustLoyalty() {
        return custLoyalty;
    }

    /** 
     * Set the 'CustLoyalty' element value.
     * 
     * @param custLoyalty
     */
    public void setCustLoyalty(CustLoyaltyType custLoyalty) {
        setChoiceSelect(CUST_LOYALTY_CHOICE);
        this.custLoyalty = custLoyalty;
    }

    /** 
     * Check if EmploymentInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifEmploymentInfo() {
        return choiceSelect == EMPLOYMENT_INFO_CHOICE;
    }

    /** 
     * Get the 'EmploymentInfo' element value.
     * 
     * @return value
     */
    public EmploymentInfoType getEmploymentInfo() {
        return employmentInfo;
    }

    /** 
     * Set the 'EmploymentInfo' element value.
     * 
     * @param employmentInfo
     */
    public void setEmploymentInfo(EmploymentInfoType employmentInfo) {
        setChoiceSelect(EMPLOYMENT_INFO_CHOICE);
        this.employmentInfo = employmentInfo;
    }

    /** 
     * Check if AirlinePref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirlinePref() {
        return choiceSelect == AIRLINE_PREF_CHOICE;
    }

    /** 
     * Get the 'AirlinePref' element value. ***OTA Based *** Airline Preference Information 
     * 
     * @return value
     */
    public PartialAirlinePrefType getAirlinePref() {
        return airlinePref;
    }

    /** 
     * Set the 'AirlinePref' element value. ***OTA Based *** Airline Preference Information 
     * 
     * @param airlinePref
     */
    public void setAirlinePref(PartialAirlinePrefType airlinePref) {
        setChoiceSelect(AIRLINE_PREF_CHOICE);
        this.airlinePref = airlinePref;
    }

    /** 
     * Check if HotelPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifHotelPref() {
        return choiceSelect == HOTEL_PREF_CHOICE;
    }

    /** 
     * Get the 'HotelPref' element value. ***OTA Based *** Hotel Preference Information 
     * 
     * @return value
     */
    public PartialHotelPrefType getHotelPref() {
        return hotelPref;
    }

    /** 
     * Set the 'HotelPref' element value. ***OTA Based *** Hotel Preference Information 
     * 
     * @param hotelPref
     */
    public void setHotelPref(PartialHotelPrefType hotelPref) {
        setChoiceSelect(HOTEL_PREF_CHOICE);
        this.hotelPref = hotelPref;
    }

    /** 
     * Check if VehicleRentalPref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifVehicleRentalPref() {
        return choiceSelect == VEHICLE_RENTAL_PREF_CHOICE;
    }

    /** 
     * Get the 'VehicleRentalPref' element value. ***OTA Based *** Vehicle Preference Information 
     * 
     * @return value
     */
    public PartialVehicleRentalPrefType getVehicleRentalPref() {
        return vehicleRentalPref;
    }

    /** 
     * Set the 'VehicleRentalPref' element value. ***OTA Based *** Vehicle Preference Information 
     * 
     * @param vehicleRentalPref
     */
    public void setVehicleRentalPref(
            PartialVehicleRentalPrefType vehicleRentalPref) {
        setChoiceSelect(VEHICLE_RENTAL_PREF_CHOICE);
        this.vehicleRentalPref = vehicleRentalPref;
    }

    /** 
     * Check if LoungePref is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLoungePref() {
        return choiceSelect == LOUNGE_PREF_CHOICE;
    }

    /** 
     * Get the 'LoungePref' element value. *** SABRE ADDED *** Lounge Preference Information 
     * 
     * @return value
     */
    public PartialLoungePrefType getLoungePref() {
        return loungePref;
    }

    /** 
     * Set the 'LoungePref' element value. *** SABRE ADDED *** Lounge Preference Information 
     * 
     * @param loungePref
     */
    public void setLoungePref(PartialLoungePrefType loungePref) {
        setChoiceSelect(LOUNGE_PREF_CHOICE);
        this.loungePref = loungePref;
    }

    /** 
     * Check if NotificationPreference is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifNotificationPreference() {
        return choiceSelect == NOTIFICATION_PREFERENCE_CHOICE;
    }

    /** 
     * Get the 'NotificationPreference' element value.
     * 
     * @return value
     */
    public NotificationPreferenceType getNotificationPreference() {
        return notificationPreference;
    }

    /** 
     * Set the 'NotificationPreference' element value.
     * 
     * @param notificationPreference
     */
    public void setNotificationPreference(
            NotificationPreferenceType notificationPreference) {
        setChoiceSelect(NOTIFICATION_PREFERENCE_CHOICE);
        this.notificationPreference = notificationPreference;
    }

    /** 
     * Check if Consent is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifConsent() {
        return choiceSelect == CONSENT_CHOICE;
    }

    /** 
     * Get the 'Consent' element value.
     * 
     * @return value
     */
    public ConsentType getConsent() {
        return consent;
    }

    /** 
     * Set the 'Consent' element value.
     * 
     * @param consent
     */
    public void setConsent(ConsentType consent) {
        setChoiceSelect(CONSENT_CHOICE);
        this.consent = consent;
    }

    /** 
     * Check if PsychographicCategory is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPsychographicCategory() {
        return choiceSelect == PSYCHOGRAPHIC_CATEGORY_CHOICE;
    }

    /** 
     * Get the 'PsychographicCategory' element value.
     * 
     * @return value
     */
    public PsychographicCategoryType getPsychographicCategory() {
        return psychographicCategory;
    }

    /** 
     * Set the 'PsychographicCategory' element value.
     * 
     * @param psychographicCategory
     */
    public void setPsychographicCategory(
            PsychographicCategoryType psychographicCategory) {
        setChoiceSelect(PSYCHOGRAPHIC_CATEGORY_CHOICE);
        this.psychographicCategory = psychographicCategory;
    }

    /** 
     * Check if PriorityRemarks is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPriorityRemarks() {
        return choiceSelect == PRIORITY_REMARKS_CHOICE;
    }

    /** 
     * Get the 'PriorityRemarks' element value.
     * 
     * @return value
     */
    public PriorityRemarksType getPriorityRemarks() {
        return priorityRemarks;
    }

    /** 
     * Set the 'PriorityRemarks' element value.
     * 
     * @param priorityRemarks
     */
    public void setPriorityRemarks(PriorityRemarksType priorityRemarks) {
        setChoiceSelect(PRIORITY_REMARKS_CHOICE);
        this.priorityRemarks = priorityRemarks;
    }

    /** 
     * Check if Remark is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRemark() {
        return choiceSelect == REMARK_CHOICE;
    }

    /** 
     * Get the 'Remark' element value.
     * 
     * @return value
     */
    public RemarkType getRemark() {
        return remark;
    }

    /** 
     * Set the 'Remark' element value.
     * 
     * @param remark
     */
    public void setRemark(RemarkType remark) {
        setChoiceSelect(REMARK_CHOICE);
        this.remark = remark;
    }

    /** 
     * Check if SSR is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSSR() {
        return choiceSelect == SSR_CHOICE;
    }

    /** 
     * Get the 'SSR' element value.
     * 
     * @return value
     */
    public SSRType getSSR() {
        return SSR;
    }

    /** 
     * Set the 'SSR' element value.
     * 
     * @param SSR
     */
    public void setSSR(SSRType SSR) {
        setChoiceSelect(SSR_CHOICE);
        this.SSR = SSR;
    }

    /** 
     * Check if CustomerReferenceInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomerReferenceInfo() {
        return choiceSelect == CUSTOMER_REFERENCE_INFO_CHOICE;
    }

    /** 
     * Get the 'CustomerReferenceInfo' element value.
     * 
     * @return value
     */
    public CustomerReferenceInfoType getCustomerReferenceInfo() {
        return customerReferenceInfo;
    }

    /** 
     * Set the 'CustomerReferenceInfo' element value.
     * 
     * @param customerReferenceInfo
     */
    public void setCustomerReferenceInfo(
            CustomerReferenceInfoType customerReferenceInfo) {
        setChoiceSelect(CUSTOMER_REFERENCE_INFO_CHOICE);
        this.customerReferenceInfo = customerReferenceInfo;
    }

    /** 
     * Check if AssociatedProfiles is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedProfiles() {
        return choiceSelect == ASSOCIATED_PROFILES_CHOICE;
    }

    /** 
     * Get the 'AssociatedProfiles' element value.
     * 
     * @return value
     */
    public AssociatedProfilesType getAssociatedProfiles() {
        return associatedProfiles;
    }

    /** 
     * Set the 'AssociatedProfiles' element value.
     * 
     * @param associatedProfiles
     */
    public void setAssociatedProfiles(AssociatedProfilesType associatedProfiles) {
        setChoiceSelect(ASSOCIATED_PROFILES_CHOICE);
        this.associatedProfiles = associatedProfiles;
    }

    /** 
     * Check if AssociatedFilters is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedFilters() {
        return choiceSelect == ASSOCIATED_FILTERS_CHOICE;
    }

    /** 
     * Get the 'AssociatedFilters' element value.
     * 
     * @return value
     */
    public AssociatedFiltersType getAssociatedFilters() {
        return associatedFilters;
    }

    /** 
     * Set the 'AssociatedFilters' element value.
     * 
     * @param associatedFilters
     */
    public void setAssociatedFilters(AssociatedFiltersType associatedFilters) {
        setChoiceSelect(ASSOCIATED_FILTERS_CHOICE);
        this.associatedFilters = associatedFilters;
    }

    /** 
     * Check if AssociatedTemplate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociatedTemplate() {
        return choiceSelect == ASSOCIATED_TEMPLATE_CHOICE;
    }

    /** 
     * Get the 'AssociatedTemplate' element value.
     * 
     * @return value
     */
    public AssociatedTemplateType getAssociatedTemplate() {
        return associatedTemplate;
    }

    /** 
     * Set the 'AssociatedTemplate' element value.
     * 
     * @param associatedTemplate
     */
    public void setAssociatedTemplate(AssociatedTemplateType associatedTemplate) {
        setChoiceSelect(ASSOCIATED_TEMPLATE_CHOICE);
        this.associatedTemplate = associatedTemplate;
    }

    /** 
     * Check if CustomDefinedData is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomDefinedData() {
        return choiceSelect == CUSTOM_DEFINED_DATA_CHOICE;
    }

    /** 
     * Get the 'CustomDefinedData' element value. *** SABRE ADDED *** Customer Defined Data
     * 
     * @return value
     */
    public CustomDefinedDataType getCustomDefinedData() {
        return customDefinedData;
    }

    /** 
     * Set the 'CustomDefinedData' element value. *** SABRE ADDED *** Customer Defined Data
     * 
     * @param customDefinedData
     */
    public void setCustomDefinedData(CustomDefinedDataType customDefinedData) {
        setChoiceSelect(CUSTOM_DEFINED_DATA_CHOICE);
        this.customDefinedData = customDefinedData;
    }

    /** 
     * Check if CustomerValueScore is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCustomerValueScore() {
        return choiceSelect == CUSTOMER_VALUE_SCORE_CHOICE;
    }

    /** 
     * Get the 'CustomerValueScore' element value. *** SABRE ADDED *** Customer Value Score Information
     * 
     * @return value
     */
    public CustomerValueScoreType getCustomerValueScore() {
        return customerValueScore;
    }

    /** 
     * Set the 'CustomerValueScore' element value. *** SABRE ADDED *** Customer Value Score Information
     * 
     * @param customerValueScore
     */
    public void setCustomerValueScore(CustomerValueScoreType customerValueScore) {
        setChoiceSelect(CUSTOMER_VALUE_SCORE_CHOICE);
        this.customerValueScore = customerValueScore;
    }

    /** 
     * Check if Login is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLogin() {
        return choiceSelect == LOGIN_CHOICE;
    }

    /** 
     * Get the 'Login' element value. DEPRECATED: In next version of schema element Login will be removed from add modify and delete subtree operation. Functionality will be replaced delivered by add, modify and delete element operations
     * 
     * @return value
     */
    public LoginType getLogin() {
        return login;
    }

    /** 
     * Set the 'Login' element value. DEPRECATED: In next version of schema element Login will be removed from add modify and delete subtree operation. Functionality will be replaced delivered by add, modify and delete element operations
     * 
     * @param login
     */
    public void setLogin(LoginType login) {
        setChoiceSelect(LOGIN_CHOICE);
        this.login = login;
    }

    /** 
     * Check if SecurityInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSecurityInfo() {
        return choiceSelect == SECURITY_INFO_CHOICE;
    }

    /** 
     * Get the 'SecurityInfo' element value.
     * 
     * @return value
     */
    public SecurityInfoType getSecurityInfo() {
        return securityInfo;
    }

    /** 
     * Set the 'SecurityInfo' element value.
     * 
     * @param securityInfo
     */
    public void setSecurityInfo(SecurityInfoType securityInfo) {
        setChoiceSelect(SECURITY_INFO_CHOICE);
        this.securityInfo = securityInfo;
    }

    /** 
     * Check if ProfileSubType is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfileSubType() {
        return choiceSelect == PROFILE_SUB_TYPE_CHOICE;
    }

    /** 
     * Get the 'ProfileSubType' element value.
     * 
     * @return value
     */
    public ProfileSubTypeType getProfileSubType() {
        return profileSubType;
    }

    /** 
     * Set the 'ProfileSubType' element value.
     * 
     * @param profileSubType
     */
    public void setProfileSubType(ProfileSubTypeType profileSubType) {
        setChoiceSelect(PROFILE_SUB_TYPE_CHOICE);
        this.profileSubType = profileSubType;
    }

    /** 
     * Check if OSI is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOSI() {
        return choiceSelect == OSI_CHOICE;
    }

    /** 
     * Get the 'OSI' element value. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @return value
     */
    public OSIType getOSI() {
        return OSI;
    }

    /** 
     * Set the 'OSI' element value. *** SABRE ADDED *** Other Service Info for a profile
     * 
     * @param OSI
     */
    public void setOSI(OSIType OSI) {
        setChoiceSelect(OSI_CHOICE);
        this.OSI = OSI;
    }

    /** 
     * Check if Discounts is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDiscounts() {
        return choiceSelect == DISCOUNTS_CHOICE;
    }

    /** 
     * Get the 'Discounts' element value.
     * 
     * @return value
     */
    public DiscountsType getDiscounts() {
        return discounts;
    }

    /** 
     * Set the 'Discounts' element value.
     * 
     * @param discounts
     */
    public void setDiscounts(DiscountsType discounts) {
        setChoiceSelect(DISCOUNTS_CHOICE);
        this.discounts = discounts;
    }
}
