
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Ways of providing funds for travel by the individual.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentFormType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TripTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ServiceUsageTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="ns:VIT_StarLineType" use="optional" name="VIT_LineType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_SecondaryQualifier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_OrderNmbr"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PaymentFormNickName"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentFormType implements Serializable
{
    private Choice choice;
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String tripTypeCode;
    private String serviceUsageTypeCode;
    private String informationText;
    private VITStarLineType VITLineType;
    private String VITSecondaryQualifier;
    private String VITOrderNmbr;
    private String paymentFormNickName;

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Payment Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Payment Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getTripTypeCode() {
        return tripTypeCode;
    }

    /** 
     * Set the 'TripTypeCode' attribute value. Trip type Code	
     * 
     * @param tripTypeCode
     */
    public void setTripTypeCode(String tripTypeCode) {
        this.tripTypeCode = tripTypeCode;
    }

    /** 
     * Get the 'ServiceUsageTypeCode' attribute value. Usage  type Code which indicated 	
     * 
     * @return value
     */
    public String getServiceUsageTypeCode() {
        return serviceUsageTypeCode;
    }

    /** 
     * Set the 'ServiceUsageTypeCode' attribute value. Usage  type Code which indicated 	
     * 
     * @param serviceUsageTypeCode
     */
    public void setServiceUsageTypeCode(String serviceUsageTypeCode) {
        this.serviceUsageTypeCode = serviceUsageTypeCode;
    }

    /** 
     * Get the 'InformationText' attribute value. Information Text

     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information Text

     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'VIT_LineType' attribute value.
     * 
     * @return value
     */
    public VITStarLineType getVITLineType() {
        return VITLineType;
    }

    /** 
     * Set the 'VIT_LineType' attribute value.
     * 
     * @param VITLineType
     */
    public void setVITLineType(VITStarLineType VITLineType) {
        this.VITLineType = VITLineType;
    }

    /** 
     * Get the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @return value
     */
    public String getVITSecondaryQualifier() {
        return VITSecondaryQualifier;
    }

    /** 
     * Set the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @param VITSecondaryQualifier
     */
    public void setVITSecondaryQualifier(String VITSecondaryQualifier) {
        this.VITSecondaryQualifier = VITSecondaryQualifier;
    }

    /** 
     * Get the 'VIT_OrderNmbr' attribute value.
     * 
     * @return value
     */
    public String getVITOrderNmbr() {
        return VITOrderNmbr;
    }

    /** 
     * Set the 'VIT_OrderNmbr' attribute value.
     * 
     * @param VITOrderNmbr
     */
    public void setVITOrderNmbr(String VITOrderNmbr) {
        this.VITOrderNmbr = VITOrderNmbr;
    }

    /** 
     * Get the 'PaymentFormNickName' attribute value. User-friendly name of this payment instrument (e.g. credit card)
     * 
     * @return value
     */
    public String getPaymentFormNickName() {
        return paymentFormNickName;
    }

    /** 
     * Set the 'PaymentFormNickName' attribute value. User-friendly name of this payment instrument (e.g. credit card)
     * 
     * @param paymentFormNickName
     */
    public void setPaymentFormNickName(String paymentFormNickName) {
        this.paymentFormNickName = paymentFormNickName;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:PaymentCardType" name="PaymentCard"/>
     *   &lt;xs:element name="Cash">
     *     &lt;!-- Reference to inner class Cash -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="Check">
     *     &lt;!-- Reference to inner class Check -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="AccountsReceivable">
     *     &lt;xs:complexType>
     *       &lt;xs:attribute type="xs:boolean" use="optional" default="true" name="Indicator"/>
     *     &lt;/xs:complexType>
     *   &lt;/xs:element>
     *   &lt;xs:element type="ns:GovernmentWarrantType" name="GovernmentWarrant"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int PAYMENT_CARD_CHOICE = 0;
        private static final int CASH_CHOICE = 1;
        private static final int CHECK_CHOICE = 2;
        private static final int ACCOUNTS_RECEIVABLE_CHOICE = 3;
        private static final int GOVERNMENT_WARRANT_CHOICE = 4;
        private PaymentCardType paymentCard;
        private Cash cash;
        private Check check;
        private Boolean accountsReceivable;
        private GovernmentWarrantType governmentWarrant;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if PaymentCard is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPaymentCard() {
            return choiceSelect == PAYMENT_CARD_CHOICE;
        }

        /** 
         * Get the 'PaymentCard' element value. Details of a debit or credit card.
         * 
         * @return value
         */
        public PaymentCardType getPaymentCard() {
            return paymentCard;
        }

        /** 
         * Set the 'PaymentCard' element value. Details of a debit or credit card.
         * 
         * @param paymentCard
         */
        public void setPaymentCard(PaymentCardType paymentCard) {
            setChoiceSelect(PAYMENT_CARD_CHOICE);
            this.paymentCard = paymentCard;
        }

        /** 
         * Check if Cash is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCash() {
            return choiceSelect == CASH_CHOICE;
        }

        /** 
         * Get the 'Cash' element value.
         * 
         * @return value
         */
        public Cash getCash() {
            return cash;
        }

        /** 
         * Set the 'Cash' element value.
         * 
         * @param cash
         */
        public void setCash(Cash cash) {
            setChoiceSelect(CASH_CHOICE);
            this.cash = cash;
        }

        /** 
         * Check if Check is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCheck() {
            return choiceSelect == CHECK_CHOICE;
        }

        /** 
         * Get the 'Check' element value.
         * 
         * @return value
         */
        public Check getCheck() {
            return check;
        }

        /** 
         * Set the 'Check' element value.
         * 
         * @param check
         */
        public void setCheck(Check check) {
            setChoiceSelect(CHECK_CHOICE);
            this.check = check;
        }

        /** 
         * Check if AccountsReceivable is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAccountsReceivable() {
            return choiceSelect == ACCOUNTS_RECEIVABLE_CHOICE;
        }

        /** 
         * Get the 'Indicator' attribute value. If true, this indicates Accounts Receivable is being used.
         * 
         * @return value
         */
        public Boolean getAccountsReceivable() {
            return accountsReceivable;
        }

        /** 
         * Set the 'Indicator' attribute value. If true, this indicates Accounts Receivable is being used.
         * 
         * @param accountsReceivable
         */
        public void setAccountsReceivable(Boolean accountsReceivable) {
            setChoiceSelect(ACCOUNTS_RECEIVABLE_CHOICE);
            this.accountsReceivable = accountsReceivable;
        }

        /** 
         * Check if GovernmentWarrant is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifGovernmentWarrant() {
            return choiceSelect == GOVERNMENT_WARRANT_CHOICE;
        }

        /** 
         * Get the 'GovernmentWarrant' element value. Government-issued warrants
         * 
         * @return value
         */
        public GovernmentWarrantType getGovernmentWarrant() {
            return governmentWarrant;
        }

        /** 
         * Set the 'GovernmentWarrant' element value. Government-issued warrants
         * 
         * @param governmentWarrant
         */
        public void setGovernmentWarrant(GovernmentWarrantType governmentWarrant) {
            setChoiceSelect(GOVERNMENT_WARRANT_CHOICE);
            this.governmentWarrant = governmentWarrant;
        }
        /** 
         * Used to indicate payment in cash.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cash">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="true" name="Indicator"/>
         *     &lt;xs:attribute type="ns:YesNoType" use="optional" name="FirstRemark"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Cash implements Serializable
        {
            private Boolean indicator;
            private YesNoType firstRemark;

            /** 
             * Get the 'Indicator' attribute value. If true, this indicates cash is being used.
             * 
             * @return value
             */
            public Boolean getIndicator() {
                return indicator;
            }

            /** 
             * Set the 'Indicator' attribute value. If true, this indicates cash is being used.
             * 
             * @param indicator
             */
            public void setIndicator(Boolean indicator) {
                this.indicator = indicator;
            }

            /** 
             * Get the 'FirstRemark' attribute value. First Remark indicator
             * 
             * @return value
             */
            public YesNoType getFirstRemark() {
                return firstRemark;
            }

            /** 
             * Set the 'FirstRemark' attribute value. First Remark indicator
             * 
             * @param firstRemark
             */
            public void setFirstRemark(YesNoType firstRemark) {
                this.firstRemark = firstRemark;
            }
        }
        /** 
         * Used to indicate payment in Check.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Check">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="BankRoutingNumber"/>
         *     &lt;xs:attribute type="ns:PaymentFormCheckCodeEnumType" use="optional" default="CK" name="PNRCheckCode"/>
         *     &lt;xs:attribute type="ns:YesNoType" use="optional" name="FirstRemark"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Check implements Serializable
        {
            private String bankRoutingNumber;
            private PaymentFormCheckCodeEnumType PNRCheckCode;
            private YesNoType firstRemark;

            /** 
             * Get the 'BankRoutingNumber' attribute value. Bank Routing Number
             * 
             * @return value
             */
            public String getBankRoutingNumber() {
                return bankRoutingNumber;
            }

            /** 
             * Set the 'BankRoutingNumber' attribute value. Bank Routing Number
             * 
             * @param bankRoutingNumber
             */
            public void setBankRoutingNumber(String bankRoutingNumber) {
                this.bankRoutingNumber = bankRoutingNumber;
            }

            /** 
             * Get the 'PNRCheckCode' attribute value. CheckCode to be move in to PNR
             * 
             * @return value
             */
            public PaymentFormCheckCodeEnumType getPNRCheckCode() {
                return PNRCheckCode;
            }

            /** 
             * Set the 'PNRCheckCode' attribute value. CheckCode to be move in to PNR
             * 
             * @param PNRCheckCode
             */
            public void setPNRCheckCode(
                    PaymentFormCheckCodeEnumType PNRCheckCode) {
                this.PNRCheckCode = PNRCheckCode;
            }

            /** 
             * Get the 'FirstRemark' attribute value. First Remark indicator
             * 
             * @return value
             */
            public YesNoType getFirstRemark() {
                return firstRemark;
            }

            /** 
             * Set the 'FirstRemark' attribute value. First Remark indicator
             * 
             * @param firstRemark
             */
            public void setFirstRemark(YesNoType firstRemark) {
                this.firstRemark = firstRemark;
            }
        }
    }
}
