
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreferredAggregatorType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="AggregatorCode"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Exclude"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderPreferenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PreferredAggregatorType implements Serializable
{
    private TransactionalDataType transactionalData;
    private String aggregatorCode;
    private Boolean exclude;
    private String informationText;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String orderPreferenceNo;

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'AggregatorCode' attribute value. Aggregator Code
     * 
     * @return value
     */
    public String getAggregatorCode() {
        return aggregatorCode;
    }

    /** 
     * Set the 'AggregatorCode' attribute value. Aggregator Code
     * 
     * @param aggregatorCode
     */
    public void setAggregatorCode(String aggregatorCode) {
        this.aggregatorCode = aggregatorCode;
    }

    /** 
     * Get the 'Exclude' attribute value. Flag this as a non preferred Aggregator
     * 
     * @return value
     */
    public Boolean getExclude() {
        return exclude;
    }

    /** 
     * Set the 'Exclude' attribute value. Flag this as a non preferred Aggregator
     * 
     * @param exclude
     */
    public void setExclude(Boolean exclude) {
        this.exclude = exclude;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Code used to identify a location.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Code used to identify a location.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'OrderPreferenceNo' attribute value. Order Preference number used to identify a location.
     * 
     * @return value
     */
    public String getOrderPreferenceNo() {
        return orderPreferenceNo;
    }

    /** 
     * Set the 'OrderPreferenceNo' attribute value. Order Preference number used to identify a location.
     * 
     * @param orderPreferenceNo
     */
    public void setOrderPreferenceNo(String orderPreferenceNo) {
        this.orderPreferenceNo = orderPreferenceNo;
    }
}
