
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreferredHotelType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:HotelRateInfoType" name="HotelRate" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="HotelName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="HotelChainCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="HotelVendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RoomTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GDSCode"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Exclude"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="HotelVicinityCode"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="SmokingInd"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="AccessibleInd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BedTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PreferLevelCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderPreferenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PreferredHotelType implements Serializable
{
    private HotelRateInfoType hotelRate;
    private TransactionalDataType transactionalData;
    private String hotelName;
    private String hotelChainCode;
    private String hotelVendorCode;
    private String roomTypeCode;
    private String informationText;
    private String GDSCode;
    private Boolean exclude;
    private String hotelVicinityCode;
    private YesNoType smokingInd;
    private YesNoType accessibleInd;
    private String bedTypeCode;
    private String preferLevelCode;
    private String orderPreferenceNo;
    private String displaySequenceNo;
    private String orderSequenceNo;

    /** 
     * Get the 'HotelRate' element value. *** SABRE ADDED *** Vehicle Rate Information
     * 
     * @return value
     */
    public HotelRateInfoType getHotelRate() {
        return hotelRate;
    }

    /** 
     * Set the 'HotelRate' element value. *** SABRE ADDED *** Vehicle Rate Information
     * 
     * @param hotelRate
     */
    public void setHotelRate(HotelRateInfoType hotelRate) {
        this.hotelRate = hotelRate;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'HotelName' attribute value. Hotel COde
     * 
     * @return value
     */
    public String getHotelName() {
        return hotelName;
    }

    /** 
     * Set the 'HotelName' attribute value. Hotel COde
     * 
     * @param hotelName
     */
    public void setHotelName(String hotelName) {
        this.hotelName = hotelName;
    }

    /** 
     * Get the 'HotelChainCode' attribute value. Hotel Chain Code. This Chain code represents the vendor codes for Brand or Management Groups of hotels.
     * 
     * @return value
     */
    public String getHotelChainCode() {
        return hotelChainCode;
    }

    /** 
     * Set the 'HotelChainCode' attribute value. Hotel Chain Code. This Chain code represents the vendor codes for Brand or Management Groups of hotels.
     * 
     * @param hotelChainCode
     */
    public void setHotelChainCode(String hotelChainCode) {
        this.hotelChainCode = hotelChainCode;
    }

    /** 
     * Get the 'HotelVendorCode' attribute value.  Vendor Code represents general Hotel Vendor Codes.
     * 
     * @return value
     */
    public String getHotelVendorCode() {
        return hotelVendorCode;
    }

    /** 
     * Set the 'HotelVendorCode' attribute value.  Vendor Code represents general Hotel Vendor Codes.
     * 
     * @param hotelVendorCode
     */
    public void setHotelVendorCode(String hotelVendorCode) {
        this.hotelVendorCode = hotelVendorCode;
    }

    /** 
     * Get the 'RoomTypeCode' attribute value. Room Type Code
     * 
     * @return value
     */
    public String getRoomTypeCode() {
        return roomTypeCode;
    }

    /** 
     * Set the 'RoomTypeCode' attribute value. Room Type Code
     * 
     * @param roomTypeCode
     */
    public void setRoomTypeCode(String roomTypeCode) {
        this.roomTypeCode = roomTypeCode;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'GDSCode' attribute value. Information about a Preferecne
     * 
     * @return value
     */
    public String getGDSCode() {
        return GDSCode;
    }

    /** 
     * Set the 'GDSCode' attribute value. Information about a Preferecne
     * 
     * @param GDSCode
     */
    public void setGDSCode(String GDSCode) {
        this.GDSCode = GDSCode;
    }

    /** 
     * Get the 'Exclude' attribute value. Flag this as a non preferred Vendor
     * 
     * @return value
     */
    public Boolean getExclude() {
        return exclude;
    }

    /** 
     * Set the 'Exclude' attribute value. Flag this as a non preferred Vendor
     * 
     * @param exclude
     */
    public void setExclude(Boolean exclude) {
        this.exclude = exclude;
    }

    /** 
     * Get the 'HotelVicinityCode' attribute value. Information about a Preferecne
     * 
     * @return value
     */
    public String getHotelVicinityCode() {
        return hotelVicinityCode;
    }

    /** 
     * Set the 'HotelVicinityCode' attribute value. Information about a Preferecne
     * 
     * @param hotelVicinityCode
     */
    public void setHotelVicinityCode(String hotelVicinityCode) {
        this.hotelVicinityCode = hotelVicinityCode;
    }

    /** 
     * Get the 'SmokingInd' attribute value. Used to indicate smoking/non-smoking preference.
     * 
     * @return value
     */
    public YesNoType getSmokingInd() {
        return smokingInd;
    }

    /** 
     * Set the 'SmokingInd' attribute value. Used to indicate smoking/non-smoking preference.
     * 
     * @param smokingInd
     */
    public void setSmokingInd(YesNoType smokingInd) {
        this.smokingInd = smokingInd;
    }

    /** 
     * Get the 'AccessibleInd' attribute value. Used to indicate customer's accessibility hotel preference.
     * 
     * @return value
     */
    public YesNoType getAccessibleInd() {
        return accessibleInd;
    }

    /** 
     * Set the 'AccessibleInd' attribute value. Used to indicate customer's accessibility hotel preference.
     * 
     * @param accessibleInd
     */
    public void setAccessibleInd(YesNoType accessibleInd) {
        this.accessibleInd = accessibleInd;
    }

    /** 
     * Get the 'BedTypeCode' attribute value. Used to indicate customer's bed type preference.
     * 
     * @return value
     */
    public String getBedTypeCode() {
        return bedTypeCode;
    }

    /** 
     * Set the 'BedTypeCode' attribute value. Used to indicate customer's bed type preference.
     * 
     * @param bedTypeCode
     */
    public void setBedTypeCode(String bedTypeCode) {
        this.bedTypeCode = bedTypeCode;
    }

    /** 
     * Get the 'PreferLevelCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @return value
     */
    public String getPreferLevelCode() {
        return preferLevelCode;
    }

    /** 
     * Set the 'PreferLevelCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @param preferLevelCode
     */
    public void setPreferLevelCode(String preferLevelCode) {
        this.preferLevelCode = preferLevelCode;
    }

    /** 
     * Get the 'OrderPreferenceNo' attribute value. Order Preference number used to identify a location.
     * 
     * @return value
     */
    public String getOrderPreferenceNo() {
        return orderPreferenceNo;
    }

    /** 
     * Set the 'OrderPreferenceNo' attribute value. Order Preference number used to identify a location.
     * 
     * @param orderPreferenceNo
     */
    public void setOrderPreferenceNo(String orderPreferenceNo) {
        this.orderPreferenceNo = orderPreferenceNo;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Code used to identify a display.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Code used to identify a display.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }
}
