
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreferredVehicleVendorsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:VehicleRateInfoType" name="VehicleRate" minOccurs="0"/>
 *     &lt;xs:element type="ns:VehicleTypeInfoType" name="VehicleType" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VehicleTypeCode"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Exclude"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PreferLevelCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderPreferenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="ns:IndicatorType" use="optional" name="SmokingInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PreferredVehicleVendorsType implements Serializable
{
    private VehicleRateInfoType vehicleRate;
    private VehicleTypeInfoType vehicleType;
    private TransactionalDataType transactionalData;
    private String vendorCode;
    private String vehicleTypeCode;
    private Boolean exclude;
    private String preferLevelCode;
    private String orderPreferenceNo;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String informationText;
    private IndicatorType smokingInd;

    /** 
     * Get the 'VehicleRate' element value. *** SABRE ADDED *** Vehicle Rate Information
     * 
     * @return value
     */
    public VehicleRateInfoType getVehicleRate() {
        return vehicleRate;
    }

    /** 
     * Set the 'VehicleRate' element value. *** SABRE ADDED *** Vehicle Rate Information
     * 
     * @param vehicleRate
     */
    public void setVehicleRate(VehicleRateInfoType vehicleRate) {
        this.vehicleRate = vehicleRate;
    }

    /** 
     * Get the 'VehicleType' element value. *** SABRE ADDED *** Vehicle Type Code Information
     * 
     * @return value
     */
    public VehicleTypeInfoType getVehicleType() {
        return vehicleType;
    }

    /** 
     * Set the 'VehicleType' element value. *** SABRE ADDED *** Vehicle Type Code Information
     * 
     * @param vehicleType
     */
    public void setVehicleType(VehicleTypeInfoType vehicleType) {
        this.vehicleType = vehicleType;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'VendorCode' attribute value. Vendor Code
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value. Vendor Code
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'VehicleTypeCode' attribute value. Vehicle Type  Code
     * 
     * @return value
     */
    public String getVehicleTypeCode() {
        return vehicleTypeCode;
    }

    /** 
     * Set the 'VehicleTypeCode' attribute value. Vehicle Type  Code
     * 
     * @param vehicleTypeCode
     */
    public void setVehicleTypeCode(String vehicleTypeCode) {
        this.vehicleTypeCode = vehicleTypeCode;
    }

    /** 
     * Get the 'Exclude' attribute value. Flag this as a non preferred Vendor
     * 
     * @return value
     */
    public Boolean getExclude() {
        return exclude;
    }

    /** 
     * Set the 'Exclude' attribute value. Flag this as a non preferred Vendor
     * 
     * @param exclude
     */
    public void setExclude(Boolean exclude) {
        this.exclude = exclude;
    }

    /** 
     * Get the 'PreferLevelCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @return value
     */
    public String getPreferLevelCode() {
        return preferLevelCode;
    }

    /** 
     * Set the 'PreferLevelCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @param preferLevelCode
     */
    public void setPreferLevelCode(String preferLevelCode) {
        this.preferLevelCode = preferLevelCode;
    }

    /** 
     * Get the 'OrderPreferenceNo' attribute value. Order Preference number used to identify a location.
     * 
     * @return value
     */
    public String getOrderPreferenceNo() {
        return orderPreferenceNo;
    }

    /** 
     * Set the 'OrderPreferenceNo' attribute value. Order Preference number used to identify a location.
     * 
     * @param orderPreferenceNo
     */
    public void setOrderPreferenceNo(String orderPreferenceNo) {
        this.orderPreferenceNo = orderPreferenceNo;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Code used to identify a display.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Code used to identify a display.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'SmokingInd' attribute value. Specifies whether a car where smoking is allowed (Y) or disallowed (N) is preferred
     * 
     * @return value
     */
    public IndicatorType getSmokingInd() {
        return smokingInd;
    }

    /** 
     * Set the 'SmokingInd' attribute value. Specifies whether a car where smoking is allowed (Y) or disallowed (N) is preferred
     * 
     * @param smokingInd
     */
    public void setSmokingInd(IndicatorType smokingInd) {
        this.smokingInd = smokingInd;
    }
}
