
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Read Only Audit/Historical Data
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileAccessInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FullAccessInfoType" name="CreateAccessInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:FullAccessInfoType" name="LastUpdateAccessInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:FullAccessInfoType" name="ReadAccessInfo" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:FullAccessInfoType" name="LastDeleteAccessInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:FullAccessInfoType" name="LastRestoreAccessInfo" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileAccessInfoType implements Serializable
{
    private FullAccessInfoType createAccessInfo;
    private FullAccessInfoType lastUpdateAccessInfo;
    private List<FullAccessInfoType> readAccessInfoList = new ArrayList<FullAccessInfoType>();
    private FullAccessInfoType lastDeleteAccessInfo;
    private FullAccessInfoType lastRestoreAccessInfo;

    /** 
     * Get the 'CreateAccessInfo' element value. ** SABRE ADDED ** Profile Create Info Data
     * 
     * @return value
     */
    public FullAccessInfoType getCreateAccessInfo() {
        return createAccessInfo;
    }

    /** 
     * Set the 'CreateAccessInfo' element value. ** SABRE ADDED ** Profile Create Info Data
     * 
     * @param createAccessInfo
     */
    public void setCreateAccessInfo(FullAccessInfoType createAccessInfo) {
        this.createAccessInfo = createAccessInfo;
    }

    /** 
     * Get the 'LastUpdateAccessInfo' element value. ** SABRE ADDED ** Profile Update Info Data
     * 
     * @return value
     */
    public FullAccessInfoType getLastUpdateAccessInfo() {
        return lastUpdateAccessInfo;
    }

    /** 
     * Set the 'LastUpdateAccessInfo' element value. ** SABRE ADDED ** Profile Update Info Data
     * 
     * @param lastUpdateAccessInfo
     */
    public void setLastUpdateAccessInfo(FullAccessInfoType lastUpdateAccessInfo) {
        this.lastUpdateAccessInfo = lastUpdateAccessInfo;
    }

    /** 
     * Get the list of 'ReadAccessInfo' element items. ** SABRE ADDED ** Profile Access Information Darta
     * 
     * @return list
     */
    public List<FullAccessInfoType> getReadAccessInfoList() {
        return readAccessInfoList;
    }

    /** 
     * Set the list of 'ReadAccessInfo' element items. ** SABRE ADDED ** Profile Access Information Darta
     * 
     * @param list
     */
    public void setReadAccessInfoList(List<FullAccessInfoType> list) {
        readAccessInfoList = list;
    }

    /** 
     * Get the 'LastDeleteAccessInfo' element value. ** SABRE ADDED ** Profile Delete Info Data
     * 
     * @return value
     */
    public FullAccessInfoType getLastDeleteAccessInfo() {
        return lastDeleteAccessInfo;
    }

    /** 
     * Set the 'LastDeleteAccessInfo' element value. ** SABRE ADDED ** Profile Delete Info Data
     * 
     * @param lastDeleteAccessInfo
     */
    public void setLastDeleteAccessInfo(FullAccessInfoType lastDeleteAccessInfo) {
        this.lastDeleteAccessInfo = lastDeleteAccessInfo;
    }

    /** 
     * Get the 'LastRestoreAccessInfo' element value. ** SABRE ADDED ** Profile Restore Info Data
     * 
     * @return value
     */
    public FullAccessInfoType getLastRestoreAccessInfo() {
        return lastRestoreAccessInfo;
    }

    /** 
     * Set the 'LastRestoreAccessInfo' element value. ** SABRE ADDED ** Profile Restore Info Data
     * 
     * @param lastRestoreAccessInfo
     */
    public void setLastRestoreAccessInfo(
            FullAccessInfoType lastRestoreAccessInfo) {
        this.lastRestoreAccessInfo = lastRestoreAccessInfo;
    }
}
