
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileEventType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ProfileEventActionType" name="Action"/>
 *     &lt;xs:element type="ns:ProfileEventIdentityType" name="TPA_Identity"/>
 *     &lt;xs:element type="ns:EventSubjectAreaType" name="SubjectArea" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileEventType implements Serializable
{
    private ProfileEventActionType action;
    private ProfileEventIdentityType TPAIdentity;
    private List<EventSubjectAreaType> subjectAreaList = new ArrayList<EventSubjectAreaType>();

    /** 
     * Get the 'Action' element value.
     * 
     * @return value
     */
    public ProfileEventActionType getAction() {
        return action;
    }

    /** 
     * Set the 'Action' element value.
     * 
     * @param action
     */
    public void setAction(ProfileEventActionType action) {
        this.action = action;
    }

    /** 
     * Get the 'TPA_Identity' element value.
     * 
     * @return value
     */
    public ProfileEventIdentityType getTPAIdentity() {
        return TPAIdentity;
    }

    /** 
     * Set the 'TPA_Identity' element value.
     * 
     * @param TPAIdentity
     */
    public void setTPAIdentity(ProfileEventIdentityType TPAIdentity) {
        this.TPAIdentity = TPAIdentity;
    }

    /** 
     * Get the list of 'SubjectArea' element items.
     * 
     * @return list
     */
    public List<EventSubjectAreaType> getSubjectAreaList() {
        return subjectAreaList;
    }

    /** 
     * Set the list of 'SubjectArea' element items.
     * 
     * @param list
     */
    public void setSubjectAreaList(List<EventSubjectAreaType> list) {
        subjectAreaList = list;
    }
}
