
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Profile identity type for BulkRead request
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileIDType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="xs:string" name="UniqueID"/>
 *     &lt;xs:element type="ns:LoginIDWithPasswordType" name="Login"/>
 *     &lt;xs:element type="ns:AuxiliaryIDType" name="AuxiliaryID"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileIDType implements Serializable
{
    private int choiceSelect = -1;
    private static final int UNIQUE_ID_CHOICE = 0;
    private static final int LOGIN_CHOICE = 1;
    private static final int AUXILIARY_ID_CHOICE = 2;
    private String uniqueID;
    private LoginIDWithPasswordType login;
    private AuxiliaryIDType auxiliaryID;
    private String domainID;
    private String clientCode;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if UniqueID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifUniqueID() {
        return choiceSelect == UNIQUE_ID_CHOICE;
    }

    /** 
     * Get the 'UniqueID' element value. Profile unique identifier
     * 
     * @return value
     */
    public String getUniqueID() {
        return uniqueID;
    }

    /** 
     * Set the 'UniqueID' element value. Profile unique identifier
     * 
     * @param uniqueID
     */
    public void setUniqueID(String uniqueID) {
        setChoiceSelect(UNIQUE_ID_CHOICE);
        this.uniqueID = uniqueID;
    }

    /** 
     * Check if Login is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLogin() {
        return choiceSelect == LOGIN_CHOICE;
    }

    /** 
     * Get the 'Login' element value.
     * 
     * @return value
     */
    public LoginIDWithPasswordType getLogin() {
        return login;
    }

    /** 
     * Set the 'Login' element value.
     * 
     * @param login
     */
    public void setLogin(LoginIDWithPasswordType login) {
        setChoiceSelect(LOGIN_CHOICE);
        this.login = login;
    }

    /** 
     * Check if AuxiliaryID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAuxiliaryID() {
        return choiceSelect == AUXILIARY_ID_CHOICE;
    }

    /** 
     * Get the 'AuxiliaryID' element value.
     * 
     * @return value
     */
    public AuxiliaryIDType getAuxiliaryID() {
        return auxiliaryID;
    }

    /** 
     * Set the 'AuxiliaryID' element value.
     * 
     * @param auxiliaryID
     */
    public void setAuxiliaryID(AuxiliaryIDType auxiliaryID) {
        setChoiceSelect(AUXILIARY_ID_CHOICE);
        this.auxiliaryID = auxiliaryID;
    }

    /** 
     * Get the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }
}
