
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfilePathType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ProfileToPNR_TPAIdentityType" name="TPA_Identity"/>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:ProfileToPNRTravelerProfileType" name="Traveler" minOccurs="0"/>
 *       &lt;xs:element type="ns:ProfileToPNRTravelAgencyProfileType" name="TravelAgency" minOccurs="0"/>
 *       &lt;xs:element type="ns:ProfileToPNRTravelAgentProfileType" name="TravelAgent" minOccurs="0"/>
 *       &lt;xs:element type="ns:ProfileToPNRCorporateProfileType" name="Corporation" minOccurs="0"/>
 *       &lt;xs:element type="ns:ProfileToPNROperationalProfileType" name="OperationalProfile" minOccurs="0"/>
 *       &lt;xs:element type="ns:ProfileToPNRGroupProfileType" name="GroupProfile" minOccurs="0"/>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="ns:ProfileToPNRAssociatedFormatType" name="AssociatedFormats" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:ProfileToPNRFormatStringType" name="FormatString" minOccurs="0" maxOccurs="100"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfilePathType implements Serializable
{
    private ProfileToPNRTPAIdentityType TPAIdentity;
    private int choiceSelect = -1;
    private static final int TRAVELER_CHOICE = 0;
    private static final int TRAVEL_AGENCY_CHOICE = 1;
    private static final int TRAVEL_AGENT_CHOICE = 2;
    private static final int CORPORATION_CHOICE = 3;
    private static final int OPERATIONAL_PROFILE_CHOICE = 4;
    private static final int GROUP_PROFILE_CHOICE = 5;
    private ProfileToPNRTravelerProfileType traveler;
    private ProfileToPNRTravelAgencyProfileType travelAgency;
    private ProfileToPNRTravelAgentProfileType travelAgent;
    private ProfileToPNRCorporateProfileType corporation;
    private ProfileToPNROperationalProfileType operationalProfile;
    private ProfileToPNRGroupProfileType groupProfile;
    private List<ProfileToPNRAssociatedFormatType> associatedFormatList = new ArrayList<ProfileToPNRAssociatedFormatType>();
    private List<ProfileToPNRFormatStringType> formatStringList = new ArrayList<ProfileToPNRFormatStringType>();

    /** 
     * Get the 'TPA_Identity' element value. ***SABRE ADDED*** To hold Identity information of a profile
     * 
     * @return value
     */
    public ProfileToPNRTPAIdentityType getTPAIdentity() {
        return TPAIdentity;
    }

    /** 
     * Set the 'TPA_Identity' element value. ***SABRE ADDED*** To hold Identity information of a profile
     * 
     * @param TPAIdentity
     */
    public void setTPAIdentity(ProfileToPNRTPAIdentityType TPAIdentity) {
        this.TPAIdentity = TPAIdentity;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Traveler is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTraveler() {
        return choiceSelect == TRAVELER_CHOICE;
    }

    /** 
     * Get the 'Traveler' element value. ***SABRE ADDED*** To hold Traveler Profile Information
     * 
     * @return value
     */
    public ProfileToPNRTravelerProfileType getTraveler() {
        return traveler;
    }

    /** 
     * Set the 'Traveler' element value. ***SABRE ADDED*** To hold Traveler Profile Information
     * 
     * @param traveler
     */
    public void setTraveler(ProfileToPNRTravelerProfileType traveler) {
        setChoiceSelect(TRAVELER_CHOICE);
        this.traveler = traveler;
    }

    /** 
     * Check if TravelAgency is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTravelAgency() {
        return choiceSelect == TRAVEL_AGENCY_CHOICE;
    }

    /** 
     * Get the 'TravelAgency' element value. ***SABRE ADDED*** To hold Travel Agency Profile 
     * 
     * @return value
     */
    public ProfileToPNRTravelAgencyProfileType getTravelAgency() {
        return travelAgency;
    }

    /** 
     * Set the 'TravelAgency' element value. ***SABRE ADDED*** To hold Travel Agency Profile 
     * 
     * @param travelAgency
     */
    public void setTravelAgency(ProfileToPNRTravelAgencyProfileType travelAgency) {
        setChoiceSelect(TRAVEL_AGENCY_CHOICE);
        this.travelAgency = travelAgency;
    }

    /** 
     * Check if TravelAgent is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTravelAgent() {
        return choiceSelect == TRAVEL_AGENT_CHOICE;
    }

    /** 
     * Get the 'TravelAgent' element value. ***SABRE ADDED*** To hold Travel Agent Profile 
     * 
     * @return value
     */
    public ProfileToPNRTravelAgentProfileType getTravelAgent() {
        return travelAgent;
    }

    /** 
     * Set the 'TravelAgent' element value. ***SABRE ADDED*** To hold Travel Agent Profile 
     * 
     * @param travelAgent
     */
    public void setTravelAgent(ProfileToPNRTravelAgentProfileType travelAgent) {
        setChoiceSelect(TRAVEL_AGENT_CHOICE);
        this.travelAgent = travelAgent;
    }

    /** 
     * Check if Corporation is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCorporation() {
        return choiceSelect == CORPORATION_CHOICE;
    }

    /** 
     * Get the 'Corporation' element value. ***SABRE ADDED*** To hold Corporation Profile 
     * 
     * @return value
     */
    public ProfileToPNRCorporateProfileType getCorporation() {
        return corporation;
    }

    /** 
     * Set the 'Corporation' element value. ***SABRE ADDED*** To hold Corporation Profile 
     * 
     * @param corporation
     */
    public void setCorporation(ProfileToPNRCorporateProfileType corporation) {
        setChoiceSelect(CORPORATION_CHOICE);
        this.corporation = corporation;
    }

    /** 
     * Check if OperationalProfile is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOperationalProfile() {
        return choiceSelect == OPERATIONAL_PROFILE_CHOICE;
    }

    /** 
     * Get the 'OperationalProfile' element value. ***SABRE ADDED*** To hold Operational Profiles data 
     * 
     * @return value
     */
    public ProfileToPNROperationalProfileType getOperationalProfile() {
        return operationalProfile;
    }

    /** 
     * Set the 'OperationalProfile' element value. ***SABRE ADDED*** To hold Operational Profiles data 
     * 
     * @param operationalProfile
     */
    public void setOperationalProfile(
            ProfileToPNROperationalProfileType operationalProfile) {
        setChoiceSelect(OPERATIONAL_PROFILE_CHOICE);
        this.operationalProfile = operationalProfile;
    }

    /** 
     * Check if GroupProfile is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifGroupProfile() {
        return choiceSelect == GROUP_PROFILE_CHOICE;
    }

    /** 
     * Get the 'GroupProfile' element value. ***SABRE ADDED*** To hold Group Profiles data 
     * 
     * @return value
     */
    public ProfileToPNRGroupProfileType getGroupProfile() {
        return groupProfile;
    }

    /** 
     * Set the 'GroupProfile' element value. ***SABRE ADDED*** To hold Group Profiles data 
     * 
     * @param groupProfile
     */
    public void setGroupProfile(ProfileToPNRGroupProfileType groupProfile) {
        setChoiceSelect(GROUP_PROFILE_CHOICE);
        this.groupProfile = groupProfile;
    }

    /** 
     * Get the list of 'AssociatedFormats' element items. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @return list
     */
    public List<ProfileToPNRAssociatedFormatType> getAssociatedFormatList() {
        return associatedFormatList;
    }

    /** 
     * Set the list of 'AssociatedFormats' element items. *** SABRE ADDED *** Information about Formats associated with a template 
     * 
     * @param list
     */
    public void setAssociatedFormatList(
            List<ProfileToPNRAssociatedFormatType> list) {
        associatedFormatList = list;
    }

    /** 
     * Get the list of 'FormatString' element items. *** SABRE ADDED *** Formats as Strings that needs to be moved direclty into PNR with out parsing 
     * 
     * @return list
     */
    public List<ProfileToPNRFormatStringType> getFormatStringList() {
        return formatStringList;
    }

    /** 
     * Set the list of 'FormatString' element items. *** SABRE ADDED *** Formats as Strings that needs to be moved direclty into PNR with out parsing 
     * 
     * @param list
     */
    public void setFormatStringList(List<ProfileToPNRFormatStringType> list) {
        formatStringList = list;
    }
}
