
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileSearchCriteriaType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:ProfileBaseCriteriaType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:SortPreferenceType" name="SortPreference" minOccurs="0"/>
 *         &lt;xs:element type="ns:SearchPaymentFormType" name="PaymentForm" minOccurs="0"/>
 *         &lt;xs:element type="ns:SearchRemarkType" name="Remark" minOccurs="0"/>
 *         &lt;xs:element type="ns:SearchDocumentType" name="Document" minOccurs="0"/>
 *         &lt;xs:element type="ns:SearchAssociatedTemplateType" name="AssociatedTemplate" minOccurs="0"/>
 *         &lt;xs:element type="ns:SearchAssociatedAssociationType" name="Association" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="ProfileNameOnly"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="PageNumber"/>
 *       &lt;xs:attribute type="xs:integer" use="optional" name="ReturnCount"/>
 *       &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="CountAll"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileSearchCriteriaType extends ProfileBaseCriteriaType
    implements Serializable
{
    private SortPreferenceType sortPreference;
    private SearchPaymentFormType paymentForm;
    private SearchRemarkType remark;
    private SearchDocumentType document;
    private SearchAssociatedTemplateType associatedTemplate;
    private SearchAssociatedAssociationType association;
    private YesNoType profileNameOnly;
    private String pageNumber;
    private BigInteger returnCount;
    private YesNoType countAll;

    /** 
     * Get the 'SortPreference' element value. 
     *** SABRE ADDED *** Associated profiles
    						
     * 
     * @return value
     */
    public SortPreferenceType getSortPreference() {
        return sortPreference;
    }

    /** 
     * Set the 'SortPreference' element value. 
     *** SABRE ADDED *** Associated profiles
    						
     * 
     * @param sortPreference
     */
    public void setSortPreference(SortPreferenceType sortPreference) {
        this.sortPreference = sortPreference;
    }

    /** 
     * Get the 'PaymentForm' element value.
     * 
     * @return value
     */
    public SearchPaymentFormType getPaymentForm() {
        return paymentForm;
    }

    /** 
     * Set the 'PaymentForm' element value.
     * 
     * @param paymentForm
     */
    public void setPaymentForm(SearchPaymentFormType paymentForm) {
        this.paymentForm = paymentForm;
    }

    /** 
     * Get the 'Remark' element value.
     * 
     * @return value
     */
    public SearchRemarkType getRemark() {
        return remark;
    }

    /** 
     * Set the 'Remark' element value.
     * 
     * @param remark
     */
    public void setRemark(SearchRemarkType remark) {
        this.remark = remark;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public SearchDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(SearchDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'AssociatedTemplate' element value.
     * 
     * @return value
     */
    public SearchAssociatedTemplateType getAssociatedTemplate() {
        return associatedTemplate;
    }

    /** 
     * Set the 'AssociatedTemplate' element value.
     * 
     * @param associatedTemplate
     */
    public void setAssociatedTemplate(
            SearchAssociatedTemplateType associatedTemplate) {
        this.associatedTemplate = associatedTemplate;
    }

    /** 
     * Get the 'Association' element value.
     * 
     * @return value
     */
    public SearchAssociatedAssociationType getAssociation() {
        return association;
    }

    /** 
     * Set the 'Association' element value.
     * 
     * @param association
     */
    public void setAssociation(SearchAssociatedAssociationType association) {
        this.association = association;
    }

    /** 
     * Get the 'ProfileNameOnly' attribute value. 
     *** SABRE ADDED *** If this is Set to Yes then only
    						Profile name and ID will be returned
    					
     * 
     * @return value
     */
    public YesNoType getProfileNameOnly() {
        return profileNameOnly;
    }

    /** 
     * Set the 'ProfileNameOnly' attribute value. 
     *** SABRE ADDED *** If this is Set to Yes then only
    						Profile name and ID will be returned
    					
     * 
     * @param profileNameOnly
     */
    public void setProfileNameOnly(YesNoType profileNameOnly) {
        this.profileNameOnly = profileNameOnly;
    }

    /** 
     * Get the 'PageNumber' attribute value. 
     *** SABRE ADDED *** Needed for repetitive search, if
    						not populated then it is considered first search
    					
     * 
     * @return value
     */
    public String getPageNumber() {
        return pageNumber;
    }

    /** 
     * Set the 'PageNumber' attribute value. 
     *** SABRE ADDED *** Needed for repetitive search, if
    						not populated then it is considered first search
    					
     * 
     * @param pageNumber
     */
    public void setPageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
    }

    /** 
     * Get the 'ReturnCount' attribute value. 
     *** SABRE ADDED *** Profiles to be returned in
    						response, if not populated then we will return
    						default count
    					
     * 
     * @return value
     */
    public BigInteger getReturnCount() {
        return returnCount;
    }

    /** 
     * Set the 'ReturnCount' attribute value. 
     *** SABRE ADDED *** Profiles to be returned in
    						response, if not populated then we will return
    						default count
    					
     * 
     * @param returnCount
     */
    public void setReturnCount(BigInteger returnCount) {
        this.returnCount = returnCount;
    }

    /** 
     * Get the 'CountAll' attribute value. 
     *** SABRE ADDED *** Default NO. If total count will be returnted in the response. Works for first page only
    					
     * 
     * @return value
     */
    public YesNoType getCountAll() {
        return countAll;
    }

    /** 
     * Set the 'CountAll' attribute value. 
     *** SABRE ADDED *** Default NO. If total count will be returnted in the response. Works for first page only
    					
     * 
     * @param countAll
     */
    public void setCountAll(YesNoType countAll) {
        this.countAll = countAll;
    }
}
