
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Profiles Associated to a Profile
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProfileToPNR_AssociatedProfilesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PNRMoveInfoType" name="PNRMoveInfo"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="AssocUniqueID"/>
 *   &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="AssocProfileTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AssocProfileName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ClientContextCode"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="TemplateInheritInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProfileToPNRAssociatedProfilesType implements Serializable
{
    private PNRMoveInfoType PNRMoveInfo;
    private TransactionalDataType transactionalData;
    private String assocUniqueID;
    private ProfileTypeInfo assocProfileTypeCode;
    private String assocProfileName;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String domainID;
    private String clientCode;
    private String clientContextCode;
    private YesNoType templateInheritInd;

    /** 
     * Get the 'PNRMoveInfo' element value. *** SABRE ADDED *** PNR Move information assocaited with an associated profiles
     * 
     * @return value
     */
    public PNRMoveInfoType getPNRMoveInfo() {
        return PNRMoveInfo;
    }

    /** 
     * Set the 'PNRMoveInfo' element value. *** SABRE ADDED *** PNR Move information assocaited with an associated profiles
     * 
     * @param PNRMoveInfo
     */
    public void setPNRMoveInfo(PNRMoveInfoType PNRMoveInfo) {
        this.PNRMoveInfo = PNRMoveInfo;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'AssocUniqueID' attribute value. *** SABRE ADDED *** Associate profileID
     * 
     * @return value
     */
    public String getAssocUniqueID() {
        return assocUniqueID;
    }

    /** 
     * Set the 'AssocUniqueID' attribute value. *** SABRE ADDED *** Associate profileID
     * 
     * @param assocUniqueID
     */
    public void setAssocUniqueID(String assocUniqueID) {
        this.assocUniqueID = assocUniqueID;
    }

    /** 
     * Get the 'AssocProfileTypeCode' attribute value. *** SABRE ADDED *** Associated Profile Type
     * 
     * @return value
     */
    public ProfileTypeInfo getAssocProfileTypeCode() {
        return assocProfileTypeCode;
    }

    /** 
     * Set the 'AssocProfileTypeCode' attribute value. *** SABRE ADDED *** Associated Profile Type
     * 
     * @param assocProfileTypeCode
     */
    public void setAssocProfileTypeCode(ProfileTypeInfo assocProfileTypeCode) {
        this.assocProfileTypeCode = assocProfileTypeCode;
    }

    /** 
     * Get the 'AssocProfileName' attribute value.
     * 
     * @return value
     */
    public String getAssocProfileName() {
        return assocProfileName;
    }

    /** 
     * Set the 'AssocProfileName' attribute value.
     * 
     * @param assocProfileName
     */
    public void setAssocProfileName(String assocProfileName) {
        this.assocProfileName = assocProfileName;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'TemplateInheritInd' attribute value. Indicates if this relation is inherited from a Template, Should be used only under Profile and not under Template and Filter.
    	
     * 
     * @return value
     */
    public YesNoType getTemplateInheritInd() {
        return templateInheritInd;
    }

    /** 
     * Set the 'TemplateInheritInd' attribute value. Indicates if this relation is inherited from a Template, Should be used only under Profile and not under Template and Filter.
    	
     * 
     * @param templateInheritInd
     */
    public void setTemplateInheritInd(YesNoType templateInheritInd) {
        this.templateInheritInd = templateInheritInd;
    }
}
