
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Queue Assignment Information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QueueAssignmentsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="QueueNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PrefatoryInstruction"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GDSCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="QueueDesc"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class QueueAssignmentsType implements Serializable
{
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String queueNo;
    private String domainID;
    private String prefatoryInstruction;
    private String GDSCode;
    private String queueDesc;
    private String displaySequenceNo;
    private String orderSequenceNo;

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'QueueNo' attribute value. Queue Number
     * 
     * @return value
     */
    public String getQueueNo() {
        return queueNo;
    }

    /** 
     * Set the 'QueueNo' attribute value. Queue Number
     * 
     * @param queueNo
     */
    public void setQueueNo(String queueNo) {
        this.queueNo = queueNo;
    }

    /** 
     * Get the 'DomainID' attribute value. ***SABRE ADDED*** Domain ID
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. ***SABRE ADDED*** Domain ID
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'PrefatoryInstruction' attribute value. ***SABRE ADDED*** Prefatory Instruction  Code
     * 
     * @return value
     */
    public String getPrefatoryInstruction() {
        return prefatoryInstruction;
    }

    /** 
     * Set the 'PrefatoryInstruction' attribute value. ***SABRE ADDED*** Prefatory Instruction  Code
     * 
     * @param prefatoryInstruction
     */
    public void setPrefatoryInstruction(String prefatoryInstruction) {
        this.prefatoryInstruction = prefatoryInstruction;
    }

    /** 
     * Get the 'GDSCode' attribute value. ***SABRE ADDED*** GDS Code
     * 
     * @return value
     */
    public String getGDSCode() {
        return GDSCode;
    }

    /** 
     * Set the 'GDSCode' attribute value. ***SABRE ADDED*** GDS Code
     * 
     * @param GDSCode
     */
    public void setGDSCode(String GDSCode) {
        this.GDSCode = GDSCode;
    }

    /** 
     * Get the 'QueueDesc' attribute value. ***SABRE ADDED*** Queue Description (Purpose)
     * 
     * @return value
     */
    public String getQueueDesc() {
        return queueDesc;
    }

    /** 
     * Set the 'QueueDesc' attribute value. ***SABRE ADDED*** Queue Description (Purpose)
     * 
     * @param queueDesc
     */
    public void setQueueDesc(String queueDesc) {
        this.queueDesc = queueDesc;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }
}
