
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Rail preferences, using IATA airport codes.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RailStationPrefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:RailStationInfoType" name="RailStationInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Exclude"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PreferLevelCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderPreferenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RailStationPrefType implements Serializable
{
    private RailStationInfoType railStationInfo;
    private TransactionalDataType transactionalData;
    private Boolean exclude;
    private String preferLevelCode;
    private String orderPreferenceNo;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String informationText;

    /** 
     * Get the 'RailStationInfo' element value.
     * 
     * @return value
     */
    public RailStationInfoType getRailStationInfo() {
        return railStationInfo;
    }

    /** 
     * Set the 'RailStationInfo' element value.
     * 
     * @param railStationInfo
     */
    public void setRailStationInfo(RailStationInfoType railStationInfo) {
        this.railStationInfo = railStationInfo;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'Exclude' attribute value. Flag this as a non preferred Aggregator
     * 
     * @return value
     */
    public Boolean getExclude() {
        return exclude;
    }

    /** 
     * Set the 'Exclude' attribute value. Flag this as a non preferred Aggregator
     * 
     * @param exclude
     */
    public void setExclude(Boolean exclude) {
        this.exclude = exclude;
    }

    /** 
     * Get the 'PreferLevelCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @return value
     */
    public String getPreferLevelCode() {
        return preferLevelCode;
    }

    /** 
     * Set the 'PreferLevelCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @param preferLevelCode
     */
    public void setPreferLevelCode(String preferLevelCode) {
        this.preferLevelCode = preferLevelCode;
    }

    /** 
     * Get the 'OrderPreferenceNo' attribute value. Order Preference number used to identify a location.
     * 
     * @return value
     */
    public String getOrderPreferenceNo() {
        return orderPreferenceNo;
    }

    /** 
     * Set the 'OrderPreferenceNo' attribute value. Order Preference number used to identify a location.
     * 
     * @param orderPreferenceNo
     */
    public void setOrderPreferenceNo(String orderPreferenceNo) {
        this.orderPreferenceNo = orderPreferenceNo;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Code used to identify a location.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Code used to identify a location.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Preferecne
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }
}
