
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RailUpgradePrefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PreferLevelCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="VendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderPreferenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RailUpgradePrefType implements Serializable
{
    private TransactionalDataType transactionalData;
    private String preferLevelCode;
    private String vendorCode;
    private String informationText;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String orderPreferenceNo;

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'PreferLevelCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @return value
     */
    public String getPreferLevelCode() {
        return preferLevelCode;
    }

    /** 
     * Set the 'PreferLevelCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @param preferLevelCode
     */
    public void setPreferLevelCode(String preferLevelCode) {
        this.preferLevelCode = preferLevelCode;
    }

    /** 
     * Get the 'VendorCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value. Used to indicate a level of preference for an associated item.
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'InformationText' attribute value. Refer to OTA Code List Seat Preference (STP).

     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Refer to OTA Code List Seat Preference (STP).

     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Code used to identify a location.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Code used to identify a location.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'OrderPreferenceNo' attribute value. Order Preference number used to identify a location.
     * 
     * @return value
     */
    public String getOrderPreferenceNo() {
        return orderPreferenceNo;
    }

    /** 
     * Set the 'OrderPreferenceNo' attribute value. Order Preference number used to identify a location.
     * 
     * @param orderPreferenceNo
     */
    public void setOrderPreferenceNo(String orderPreferenceNo) {
        this.orderPreferenceNo = orderPreferenceNo;
    }
}
