
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReadMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataIDType">
 *       &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *       &lt;xs:attribute type="ns:ProfileTypeInfo" use="optional" name="ProfileTypeCode"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReadMetadataType extends MetadataIDType implements Serializable
{
    private String clientContextCode;
    private ProfileTypeInfo profileTypeCode;

    /** 
     * Get the 'ClientContextCode' attribute value. ClientContextCode indicated calling applications ex: MYS, NTC
    					
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. ClientContextCode indicated calling applications ex: MYS, NTC
    					
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'ProfileTypeCode' attribute value. *** DEPRECATED *** Profile Type code of Profile this Metadata binded to
     * 
     * @return value
     */
    public ProfileTypeInfo getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value. *** DEPRECATED *** Profile Type code of Profile this Metadata binded to
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(ProfileTypeInfo profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }
}
