
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Root element for profile content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReadProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TPAIdentityType" name="TPA_Identity"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReadProfileType implements Serializable
{
    private TPAIdentityType TPAIdentity;
    private Choice choice;

    /** 
     * Get the 'TPA_Identity' element value.
     * 
     * @return value
     */
    public TPAIdentityType getTPAIdentity() {
        return TPAIdentity;
    }

    /** 
     * Set the 'TPA_Identity' element value.
     * 
     * @param TPAIdentity
     */
    public void setTPAIdentity(TPAIdentityType TPAIdentity) {
        this.TPAIdentity = TPAIdentity;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:IgnoreReadSubjectAreasType" name="IgnoreReadSubjectAreas" minOccurs="0"/>
     *   &lt;xs:element type="ns:PartialReadSubjectAreasType" name="PartialReadSubjectAreas" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int IGNORE_READ_SUBJECT_AREAS_CHOICE = 0;
        private static final int PARTIAL_READ_SUBJECT_AREAS_CHOICE = 1;
        private IgnoreReadSubjectAreasType ignoreReadSubjectAreas;
        private PartialReadSubjectAreasType partialReadSubjectAreas;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if IgnoreReadSubjectAreas is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifIgnoreReadSubjectAreas() {
            return choiceSelect == IGNORE_READ_SUBJECT_AREAS_CHOICE;
        }

        /** 
         * Get the 'IgnoreReadSubjectAreas' element value.
         * 
         * @return value
         */
        public IgnoreReadSubjectAreasType getIgnoreReadSubjectAreas() {
            return ignoreReadSubjectAreas;
        }

        /** 
         * Set the 'IgnoreReadSubjectAreas' element value.
         * 
         * @param ignoreReadSubjectAreas
         */
        public void setIgnoreReadSubjectAreas(
                IgnoreReadSubjectAreasType ignoreReadSubjectAreas) {
            setChoiceSelect(IGNORE_READ_SUBJECT_AREAS_CHOICE);
            this.ignoreReadSubjectAreas = ignoreReadSubjectAreas;
        }

        /** 
         * Check if PartialReadSubjectAreas is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPartialReadSubjectAreas() {
            return choiceSelect == PARTIAL_READ_SUBJECT_AREAS_CHOICE;
        }

        /** 
         * Get the 'PartialReadSubjectAreas' element value.
         * 
         * @return value
         */
        public PartialReadSubjectAreasType getPartialReadSubjectAreas() {
            return partialReadSubjectAreas;
        }

        /** 
         * Set the 'PartialReadSubjectAreas' element value.
         * 
         * @param partialReadSubjectAreas
         */
        public void setPartialReadSubjectAreas(
                PartialReadSubjectAreasType partialReadSubjectAreas) {
            setChoiceSelect(PARTIAL_READ_SUBJECT_AREAS_CHOICE);
            this.partialReadSubjectAreas = partialReadSubjectAreas;
        }
    }
}
