
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Returns multiple profiles
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReadRSProfilesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ProfileType" name="Profile" maxOccurs="700"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReadRSProfilesType implements Serializable
{
    private List<ProfileType> profileList = new ArrayList<ProfileType>();

    /** 
     * Get the list of 'Profile' element items. *** OTA Based *** If name search finds more than one profile choose VITProfiles
     * 
     * @return list
     */
    public List<ProfileType> getProfileList() {
        return profileList;
    }

    /** 
     * Set the list of 'Profile' element items. *** OTA Based *** If name search finds more than one profile choose VITProfiles
     * 
     * @param list
     */
    public void setProfileList(List<ProfileType> list) {
        profileList = list;
    }
}
