
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Remarks for a Profile
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RemarkType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="Text"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CategoryCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="ns:VIT_StarLineType" use="optional" name="VIT_LineType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_SecondaryQualifier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_OrderNmbr"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RemarkType implements Serializable
{
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String text;
    private String typeCode;
    private String categoryCode;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private VITStarLineType VITLineType;
    private String VITSecondaryQualifier;
    private String VITOrderNmbr;

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'Text' attribute value.
     * 
     * @return value
     */
    public String getText() {
        return text;
    }

    /** 
     * Set the 'Text' attribute value.
     * 
     * @param text
     */
    public void setText(String text) {
        this.text = text;
    }

    /** 
     * Get the 'TypeCode' attribute value.
     * 
     * @return value
     */
    public String getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' attribute value.
     * 
     * @param typeCode
     */
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    /** 
     * Get the 'CategoryCode' attribute value.
     * 
     * @return value
     */
    public String getCategoryCode() {
        return categoryCode;
    }

    /** 
     * Set the 'CategoryCode' attribute value.
     * 
     * @param categoryCode
     */
    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'VIT_LineType' attribute value.
     * 
     * @return value
     */
    public VITStarLineType getVITLineType() {
        return VITLineType;
    }

    /** 
     * Set the 'VIT_LineType' attribute value.
     * 
     * @param VITLineType
     */
    public void setVITLineType(VITStarLineType VITLineType) {
        this.VITLineType = VITLineType;
    }

    /** 
     * Get the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @return value
     */
    public String getVITSecondaryQualifier() {
        return VITSecondaryQualifier;
    }

    /** 
     * Set the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @param VITSecondaryQualifier
     */
    public void setVITSecondaryQualifier(String VITSecondaryQualifier) {
        this.VITSecondaryQualifier = VITSecondaryQualifier;
    }

    /** 
     * Get the 'VIT_OrderNmbr' attribute value.
     * 
     * @return value
     */
    public String getVITOrderNmbr() {
        return VITOrderNmbr;
    }

    /** 
     * Set the 'VIT_OrderNmbr' attribute value.
     * 
     * @param VITOrderNmbr
     */
    public void setVITOrderNmbr(String VITOrderNmbr) {
        this.VITOrderNmbr = VITOrderNmbr;
    }
}
