
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * *** SABRE ADDED *** Response for RetrieveCustomFieldCodes
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetrieveCustomFieldCodesRSType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Message" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CustomFieldCode" minOccurs="0" maxOccurs="250"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RetrieveCustomFieldCodesRSType implements Serializable
{
    private String message;
    private List<String> customFieldCodeList = new ArrayList<String>();
    private String clientCode;
    private String clientContextCode;
    private String domainID;

    /** 
     * Get the 'Message' element value. *** SABRE ADDED ***Response Messages
     * 
     * @return value
     */
    public String getMessage() {
        return message;
    }

    /** 
     * Set the 'Message' element value. *** SABRE ADDED ***Response Messages
     * 
     * @param message
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /** 
     * Get the list of 'CustomFieldCode' element items.
     * 
     * @return list
     */
    public List<String> getCustomFieldCodeList() {
        return customFieldCodeList;
    }

    /** 
     * Set the list of 'CustomFieldCode' element items.
     * 
     * @param list
     */
    public void setCustomFieldCodeList(List<String> list) {
        customFieldCodeList = list;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles		
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles		
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }
}
