
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RolesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CustomProfileRolesType" name="CustomProfileRoles" minOccurs="0" maxOccurs="50"/>
 *     &lt;xs:element type="ns:StandardProfileRolesType" name="StandardProfileRoles" minOccurs="0" maxOccurs="50"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RolesType implements Serializable
{
    private List<CustomProfileRolesType> customProfileRoleList = new ArrayList<CustomProfileRolesType>();
    private List<StandardProfileRolesType> standardProfileRoleList = new ArrayList<StandardProfileRolesType>();

    /** 
     * Get the list of 'CustomProfileRoles' element items. *** SABRE ADDED *** Custom Roles Associated to a profile created by User Roles application 
     * 
     * @return list
     */
    public List<CustomProfileRolesType> getCustomProfileRoleList() {
        return customProfileRoleList;
    }

    /** 
     * Set the list of 'CustomProfileRoles' element items. *** SABRE ADDED *** Custom Roles Associated to a profile created by User Roles application 
     * 
     * @param list
     */
    public void setCustomProfileRoleList(List<CustomProfileRolesType> list) {
        customProfileRoleList = list;
    }

    /** 
     * Get the list of 'StandardProfileRoles' element items. *** SABRE ADDED *** Standard Roles Associated to a profile based on predefined list like SiteRole, AdminRole etc 
     * 
     * @return list
     */
    public List<StandardProfileRolesType> getStandardProfileRoleList() {
        return standardProfileRoleList;
    }

    /** 
     * Set the list of 'StandardProfileRoles' element items. *** SABRE ADDED *** Standard Roles Associated to a profile based on predefined list like SiteRole, AdminRole etc 
     * 
     * @param list
     */
    public void setStandardProfileRoleList(List<StandardProfileRolesType> list) {
        standardProfileRoleList = list;
    }
}
