
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Bulk read request for reading multiple profiles, filters, formats, metadata, validators and associations. Note: order of elements is not preserved in response.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileBulkReadRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="Profiles" minOccurs="0">
 *         &lt;!-- Reference to inner class Profiles -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Filters" minOccurs="0">
 *         &lt;!-- Reference to inner class Filters -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Formats" minOccurs="0">
 *         &lt;!-- Reference to inner class Formats -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Metadatas" minOccurs="0">
 *         &lt;!-- Reference to inner class Metadatas -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Validators" minOccurs="0">
 *         &lt;!-- Reference to inner class Validators -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Associations" minOccurs="0">
 *         &lt;!-- Reference to inner class Associations -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *     &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="IgnoreStatusCheck"/>
 *     &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="RequestTrackingID"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileBulkReadRQ implements Serializable
{
    private Profiles profiles;
    private Filters filters;
    private Formats formats;
    private Metadatas metadatas;
    private Validators validators;
    private Associations associations;
    private Date timeStamp;
    private Target target;
    private String version;
    private YesNoType ignoreStatusCheck;
    private String clientContextCode;
    private String requestTrackingID;

    /** 
     * Get the 'Profiles' element value.
     * 
     * @return value
     */
    public Profiles getProfiles() {
        return profiles;
    }

    /** 
     * Set the 'Profiles' element value.
     * 
     * @param profiles
     */
    public void setProfiles(Profiles profiles) {
        this.profiles = profiles;
    }

    /** 
     * Get the 'Filters' element value.
     * 
     * @return value
     */
    public Filters getFilters() {
        return filters;
    }

    /** 
     * Set the 'Filters' element value.
     * 
     * @param filters
     */
    public void setFilters(Filters filters) {
        this.filters = filters;
    }

    /** 
     * Get the 'Formats' element value.
     * 
     * @return value
     */
    public Formats getFormats() {
        return formats;
    }

    /** 
     * Set the 'Formats' element value.
     * 
     * @param formats
     */
    public void setFormats(Formats formats) {
        this.formats = formats;
    }

    /** 
     * Get the 'Metadatas' element value.
     * 
     * @return value
     */
    public Metadatas getMetadatas() {
        return metadatas;
    }

    /** 
     * Set the 'Metadatas' element value.
     * 
     * @param metadatas
     */
    public void setMetadatas(Metadatas metadatas) {
        this.metadatas = metadatas;
    }

    /** 
     * Get the 'Validators' element value.
     * 
     * @return value
     */
    public Validators getValidators() {
        return validators;
    }

    /** 
     * Set the 'Validators' element value.
     * 
     * @param validators
     */
    public void setValidators(Validators validators) {
        this.validators = validators;
    }

    /** 
     * Get the 'Associations' element value.
     * 
     * @return value
     */
    public Associations getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' element value.
     * 
     * @param associations
     */
    public void setAssociations(Associations associations) {
        this.associations = associations;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'IgnoreStatusCheck' attribute value. If set to Y, profile status (e.g. AC, IN, DL, ...) will not be validated. All profiles could be read.
     * 
     * @return value
     */
    public YesNoType getIgnoreStatusCheck() {
        return ignoreStatusCheck;
    }

    /** 
     * Set the 'IgnoreStatusCheck' attribute value. If set to Y, profile status (e.g. AC, IN, DL, ...) will not be validated. All profiles could be read.
     * 
     * @param ignoreStatusCheck
     */
    public void setIgnoreStatusCheck(YesNoType ignoreStatusCheck) {
        this.ignoreStatusCheck = ignoreStatusCheck;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. ClientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. ClientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'RequestTrackingID' attribute value.
     * 
     * @return value
     */
    public String getRequestTrackingID() {
        return requestTrackingID;
    }

    /** 
     * Set the 'RequestTrackingID' attribute value.
     * 
     * @param requestTrackingID
     */
    public void setRequestTrackingID(String requestTrackingID) {
        this.requestTrackingID = requestTrackingID;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Profiles" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Profile" maxOccurs="10">
     *         &lt;!-- Reference to inner class Profile -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Profiles implements Serializable
    {
        private List<Profile> profileList = new ArrayList<Profile>();

        /** 
         * Get the list of 'Profile' element items.
         * 
         * @return list
         */
        public List<Profile> getProfileList() {
            return profileList;
        }

        /** 
         * Set the list of 'Profile' element items.
         * 
         * @param list
         */
        public void setProfileList(List<Profile> list) {
            profileList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Profile" maxOccurs="10">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ProfileIDType" name="Identity"/>
         *       &lt;xs:choice>
         *         &lt;xs:element type="ns:IgnoreReadSubjectAreasType" name="IgnoreReadSubjectAreas" minOccurs="0"/>
         *         &lt;xs:element type="ns:PartialReadSubjectAreasType" name="PartialReadSubjectAreas" minOccurs="0"/>
         *       &lt;/xs:choice>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="ProfileTypeCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Profile implements Serializable
        {
            private ProfileIDType identity;
            private int choiceSelect = -1;
            private static final int IGNORE_READ_SUBJECT_AREAS_CHOICE = 0;
            private static final int PARTIAL_READ_SUBJECT_AREAS_CHOICE = 1;
            private IgnoreReadSubjectAreasType ignoreReadSubjectAreas;
            private PartialReadSubjectAreasType partialReadSubjectAreas;
            private ProfileTypeInfo profileTypeCode;

            /** 
             * Get the 'Identity' element value.
             * 
             * @return value
             */
            public ProfileIDType getIdentity() {
                return identity;
            }

            /** 
             * Set the 'Identity' element value.
             * 
             * @param identity
             */
            public void setIdentity(ProfileIDType identity) {
                this.identity = identity;
            }

            private void setChoiceSelect(int choice) {
                if (choiceSelect == -1) {
                    choiceSelect = choice;
                } else if (choiceSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceSelect() {
                choiceSelect = -1;
            }

            /** 
             * Check if IgnoreReadSubjectAreas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifIgnoreReadSubjectAreas() {
                return choiceSelect == IGNORE_READ_SUBJECT_AREAS_CHOICE;
            }

            /** 
             * Get the 'IgnoreReadSubjectAreas' element value.
             * 
             * @return value
             */
            public IgnoreReadSubjectAreasType getIgnoreReadSubjectAreas() {
                return ignoreReadSubjectAreas;
            }

            /** 
             * Set the 'IgnoreReadSubjectAreas' element value.
             * 
             * @param ignoreReadSubjectAreas
             */
            public void setIgnoreReadSubjectAreas(
                    IgnoreReadSubjectAreasType ignoreReadSubjectAreas) {
                setChoiceSelect(IGNORE_READ_SUBJECT_AREAS_CHOICE);
                this.ignoreReadSubjectAreas = ignoreReadSubjectAreas;
            }

            /** 
             * Check if PartialReadSubjectAreas is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifPartialReadSubjectAreas() {
                return choiceSelect == PARTIAL_READ_SUBJECT_AREAS_CHOICE;
            }

            /** 
             * Get the 'PartialReadSubjectAreas' element value.
             * 
             * @return value
             */
            public PartialReadSubjectAreasType getPartialReadSubjectAreas() {
                return partialReadSubjectAreas;
            }

            /** 
             * Set the 'PartialReadSubjectAreas' element value.
             * 
             * @param partialReadSubjectAreas
             */
            public void setPartialReadSubjectAreas(
                    PartialReadSubjectAreasType partialReadSubjectAreas) {
                setChoiceSelect(PARTIAL_READ_SUBJECT_AREAS_CHOICE);
                this.partialReadSubjectAreas = partialReadSubjectAreas;
            }

            /** 
             * Get the 'ProfileTypeCode' attribute value. Profile type information
             * 
             * @return value
             */
            public ProfileTypeInfo getProfileTypeCode() {
                return profileTypeCode;
            }

            /** 
             * Set the 'ProfileTypeCode' attribute value. Profile type information
             * 
             * @param profileTypeCode
             */
            public void setProfileTypeCode(ProfileTypeInfo profileTypeCode) {
                this.profileTypeCode = profileTypeCode;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Filters" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FilterIDType" name="Filter" maxOccurs="10"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Filters implements Serializable
    {
        private List<FilterIDType> filterList = new ArrayList<FilterIDType>();

        /** 
         * Get the list of 'Filter' element items.
         * 
         * @return list
         */
        public List<FilterIDType> getFilterList() {
            return filterList;
        }

        /** 
         * Set the list of 'Filter' element items.
         * 
         * @param list
         */
        public void setFilterList(List<FilterIDType> list) {
            filterList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Formats" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FormatIDType" name="Format" maxOccurs="10"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Formats implements Serializable
    {
        private List<FormatIDType> formatList = new ArrayList<FormatIDType>();

        /** 
         * Get the list of 'Format' element items.
         * 
         * @return list
         */
        public List<FormatIDType> getFormatList() {
            return formatList;
        }

        /** 
         * Set the list of 'Format' element items.
         * 
         * @param list
         */
        public void setFormatList(List<FormatIDType> list) {
            formatList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Metadatas" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:MetadataIDType" name="Metadata" maxOccurs="10"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Metadatas implements Serializable
    {
        private List<MetadataIDType> metadataList = new ArrayList<MetadataIDType>();

        /** 
         * Get the list of 'Metadata' element items. Information about structure of a Metadata 
         * 
         * @return list
         */
        public List<MetadataIDType> getMetadataList() {
            return metadataList;
        }

        /** 
         * Set the list of 'Metadata' element items. Information about structure of a Metadata 
         * 
         * @param list
         */
        public void setMetadataList(List<MetadataIDType> list) {
            metadataList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Validators" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:ValidatorIDType" name="Validator" maxOccurs="10"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Validators implements Serializable
    {
        private List<ValidatorIDType> validatorList = new ArrayList<ValidatorIDType>();

        /** 
         * Get the list of 'Validator' element items. Information about structure of a Validator
         * 
         * @return list
         */
        public List<ValidatorIDType> getValidatorList() {
            return validatorList;
        }

        /** 
         * Set the list of 'Validator' element items. Information about structure of a Validator
         * 
         * @param list
         */
        public void setValidatorList(List<ValidatorIDType> list) {
            validatorList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:AssociationIDType" name="Association" maxOccurs="10"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Associations implements Serializable
    {
        private List<AssociationIDType> associationList = new ArrayList<AssociationIDType>();

        /** 
         * Get the list of 'Association' element items. Information about structure of an Association
         * 
         * @return list
         */
        public List<AssociationIDType> getAssociationList() {
            return associationList;
        }

        /** 
         * Set the list of 'Association' element items. Information about structure of an Association
         * 
         * @param list
         */
        public void setAssociationList(List<AssociationIDType> list) {
            associationList = list;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
