
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Returns a multiple customer profiles, templates, filters and formats in response to a ReadRQ request of Type=Profile. Order of elements doesn't have to be the same as in request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileBulkReadRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:BulkReadResponseMessageType" name="ResponseMessage"/>
 *       &lt;xs:sequence minOccurs="0">
 *         &lt;!-- Reference to inner class Sequence -->
 *       &lt;/xs:sequence>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="RequestTrackingID"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileBulkReadRS implements Serializable
{
    private BulkReadResponseMessageType responseMessage;
    private Sequence sequence;
    private Date timeStamp;
    private Target target;
    private String version;
    private String requestTrackingID;

    /** 
     * Get the 'ResponseMessage' element value. *** SABRE ADDED *** Response Messages
     * 
     * @return value
     */
    public BulkReadResponseMessageType getResponseMessage() {
        return responseMessage;
    }

    /** 
     * Set the 'ResponseMessage' element value. *** SABRE ADDED *** Response Messages
     * 
     * @param responseMessage
     */
    public void setResponseMessage(BulkReadResponseMessageType responseMessage) {
        this.responseMessage = responseMessage;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getSequence() {
        return sequence;
    }

    /** 
     * Set the sequence value.
     * 
     * @param sequence
     */
    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @return value
     */
    public String getRequestTrackingID() {
        return requestTrackingID;
    }

    /** 
     * Set the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @param requestTrackingID
     */
    public void setRequestTrackingID(String requestTrackingID) {
        this.requestTrackingID = requestTrackingID;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element name="Profiles" minOccurs="0">
     *     &lt;!-- Reference to inner class Profiles -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="Filters" minOccurs="0">
     *     &lt;!-- Reference to inner class Filters -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="Formats" minOccurs="0">
     *     &lt;!-- Reference to inner class Formats -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="Metadatas" minOccurs="0">
     *     &lt;!-- Reference to inner class Metadatas -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="Validators" minOccurs="0">
     *     &lt;!-- Reference to inner class Validators -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="Associations" minOccurs="0">
     *     &lt;!-- Reference to inner class Associations -->
     *   &lt;/xs:element>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private Profiles profiles;
        private Filters filters;
        private Formats formats;
        private Metadatas metadatas;
        private Validators validators;
        private Associations associations;

        /** 
         * Get the 'Profiles' element value.
         * 
         * @return value
         */
        public Profiles getProfiles() {
            return profiles;
        }

        /** 
         * Set the 'Profiles' element value.
         * 
         * @param profiles
         */
        public void setProfiles(Profiles profiles) {
            this.profiles = profiles;
        }

        /** 
         * Get the 'Filters' element value.
         * 
         * @return value
         */
        public Filters getFilters() {
            return filters;
        }

        /** 
         * Set the 'Filters' element value.
         * 
         * @param filters
         */
        public void setFilters(Filters filters) {
            this.filters = filters;
        }

        /** 
         * Get the 'Formats' element value.
         * 
         * @return value
         */
        public Formats getFormats() {
            return formats;
        }

        /** 
         * Set the 'Formats' element value.
         * 
         * @param formats
         */
        public void setFormats(Formats formats) {
            this.formats = formats;
        }

        /** 
         * Get the 'Metadatas' element value.
         * 
         * @return value
         */
        public Metadatas getMetadatas() {
            return metadatas;
        }

        /** 
         * Set the 'Metadatas' element value.
         * 
         * @param metadatas
         */
        public void setMetadatas(Metadatas metadatas) {
            this.metadatas = metadatas;
        }

        /** 
         * Get the 'Validators' element value.
         * 
         * @return value
         */
        public Validators getValidators() {
            return validators;
        }

        /** 
         * Set the 'Validators' element value.
         * 
         * @param validators
         */
        public void setValidators(Validators validators) {
            this.validators = validators;
        }

        /** 
         * Get the 'Associations' element value.
         * 
         * @return value
         */
        public Associations getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value.
         * 
         * @param associations
         */
        public void setAssociations(Associations associations) {
            this.associations = associations;
        }
        /** 
         * *** OTA Based *** If name search finds more than one profile choose VITProfiles
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Profiles" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ProfileType" name="Profile" maxOccurs="10"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Profiles implements Serializable
        {
            private List<ProfileType> profileList = new ArrayList<ProfileType>();

            /** 
             * Get the list of 'Profile' element items.
             * 
             * @return list
             */
            public List<ProfileType> getProfileList() {
                return profileList;
            }

            /** 
             * Set the list of 'Profile' element items.
             * 
             * @param list
             */
            public void setProfileList(List<ProfileType> list) {
                profileList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Filters" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:FilterType" name="Filter" maxOccurs="10"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Filters implements Serializable
        {
            private List<FilterType> filterList = new ArrayList<FilterType>();

            /** 
             * Get the list of 'Filter' element items.
             * 
             * @return list
             */
            public List<FilterType> getFilterList() {
                return filterList;
            }

            /** 
             * Set the list of 'Filter' element items.
             * 
             * @param list
             */
            public void setFilterList(List<FilterType> list) {
                filterList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Formats" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:FormatType" name="Format" maxOccurs="10"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Formats implements Serializable
        {
            private List<FormatType> formatList = new ArrayList<FormatType>();

            /** 
             * Get the list of 'Format' element items.
             * 
             * @return list
             */
            public List<FormatType> getFormatList() {
                return formatList;
            }

            /** 
             * Set the list of 'Format' element items.
             * 
             * @param list
             */
            public void setFormatList(List<FormatType> list) {
                formatList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Metadatas" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:MetadataType" name="Metadata" maxOccurs="10"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Metadatas implements Serializable
        {
            private List<MetadataType> metadataList = new ArrayList<MetadataType>();

            /** 
             * Get the list of 'Metadata' element items.
             * 
             * @return list
             */
            public List<MetadataType> getMetadataList() {
                return metadataList;
            }

            /** 
             * Set the list of 'Metadata' element items.
             * 
             * @param list
             */
            public void setMetadataList(List<MetadataType> list) {
                metadataList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Validators" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ValidatorType" name="Validator" maxOccurs="10"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Validators implements Serializable
        {
            private List<ValidatorType> validatorList = new ArrayList<ValidatorType>();

            /** 
             * Get the list of 'Validator' element items.
             * 
             * @return list
             */
            public List<ValidatorType> getValidatorList() {
                return validatorList;
            }

            /** 
             * Set the list of 'Validator' element items.
             * 
             * @param list
             */
            public void setValidatorList(List<ValidatorType> list) {
                validatorList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:AssociationType" name="Association" maxOccurs="10"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Associations implements Serializable
        {
            private List<AssociationType> associationList = new ArrayList<AssociationType>();

            /** 
             * Get the list of 'Association' element items.
             * 
             * @return list
             */
            public List<AssociationType> getAssociationList() {
                return associationList;
            }

            /** 
             * Set the list of 'Association' element items.
             * 
             * @param list
             */
            public void setAssociationList(List<AssociationType> list) {
                associationList = list;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
