
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileCreateRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:choice>
 *         &lt;xs:element type="ns:ProfileType" name="Profile"/>
 *         &lt;xs:element type="ns:TemplateType" name="Template"/>
 *         &lt;xs:element type="ns:MetadataType" name="Metadata"/>
 *         &lt;xs:element type="ns:ValidatorType" name="Validator"/>
 *         &lt;xs:element type="ns:AssociationType" name="Association"/>
 *         &lt;xs:element type="ns:FilterType" name="Filter"/>
 *         &lt;xs:element type="ns:FormatType" name="Format"/>
 *         &lt;xs:element type="ns:ConfigurationType" name="Configuration"/>
 *       &lt;/xs:choice>
 *       &lt;xs:element type="ns:AccessInfoType" name="CreateAccessInfo" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *     &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="IgnoreDataErrors"/>
 *     &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="UpdateByDataSourceInfo"/>
 *     &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="ProfileDuplicateCheck"/>
 *     &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="GenerateLoginID"/>
 *     &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="GeneratePassword"/>
 *     &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="GenerateMembershipID"/>
 *     &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="IgnoreStatusCheck"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="RequestTrackingID"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileCreateRQ implements Serializable
{
    private int choiceSelect = -1;
    private static final int PROFILE_CHOICE = 0;
    private static final int TEMPLATE_CHOICE = 1;
    private static final int METADATA_CHOICE = 2;
    private static final int VALIDATOR_CHOICE = 3;
    private static final int ASSOCIATION_CHOICE = 4;
    private static final int FILTER_CHOICE = 5;
    private static final int FORMAT_CHOICE = 6;
    private static final int CONFIGURATION_CHOICE = 7;
    private ProfileType profile;
    private TemplateType template;
    private MetadataType metadata;
    private ValidatorType validator;
    private AssociationType association;
    private FilterType filter;
    private FormatType format;
    private ConfigurationType configuration;
    private AccessInfoType createAccessInfo;
    private Date timeStamp;
    private Target target;
    private String version;
    private YesNoType ignoreDataErrors;
    private YesNoType updateByDataSourceInfo;
    private YesNoType profileDuplicateCheck;
    private YesNoType generateLoginID;
    private YesNoType generatePassword;
    private YesNoType generateMembershipID;
    private YesNoType ignoreStatusCheck;
    private String requestTrackingID;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Profile is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfile() {
        return choiceSelect == PROFILE_CHOICE;
    }

    /** 
     * Get the 'Profile' element value. *** OTA Based *** Information about a profile, data can hold any type of profile 
     * 
     * @return value
     */
    public ProfileType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value. *** OTA Based *** Information about a profile, data can hold any type of profile 
     * 
     * @param profile
     */
    public void setProfile(ProfileType profile) {
        setChoiceSelect(PROFILE_CHOICE);
        this.profile = profile;
    }

    /** 
     * Check if Template is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTemplate() {
        return choiceSelect == TEMPLATE_CHOICE;
    }

    /** 
     * Get the 'Template' element value. *** SABRE ADDED *** Information about structure of a template
     * 
     * @return value
     */
    public TemplateType getTemplate() {
        return template;
    }

    /** 
     * Set the 'Template' element value. *** SABRE ADDED *** Information about structure of a template
     * 
     * @param template
     */
    public void setTemplate(TemplateType template) {
        setChoiceSelect(TEMPLATE_CHOICE);
        this.template = template;
    }

    /** 
     * Check if Metadata is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMetadata() {
        return choiceSelect == METADATA_CHOICE;
    }

    /** 
     * Get the 'Metadata' element value. *** SABRE ADDED *** Information about structure of a Metadata 
     * 
     * @return value
     */
    public MetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. *** SABRE ADDED *** Information about structure of a Metadata 
     * 
     * @param metadata
     */
    public void setMetadata(MetadataType metadata) {
        setChoiceSelect(METADATA_CHOICE);
        this.metadata = metadata;
    }

    /** 
     * Check if Validator is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifValidator() {
        return choiceSelect == VALIDATOR_CHOICE;
    }

    /** 
     * Get the 'Validator' element value. *** SABRE ADDED *** Information about structure of a Validator
     * 
     * @return value
     */
    public ValidatorType getValidator() {
        return validator;
    }

    /** 
     * Set the 'Validator' element value. *** SABRE ADDED *** Information about structure of a Validator
     * 
     * @param validator
     */
    public void setValidator(ValidatorType validator) {
        setChoiceSelect(VALIDATOR_CHOICE);
        this.validator = validator;
    }

    /** 
     * Check if Association is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociation() {
        return choiceSelect == ASSOCIATION_CHOICE;
    }

    /** 
     * Get the 'Association' element value. *** SABRE ADDED *** Information about structure of an Association
     * 
     * @return value
     */
    public AssociationType getAssociation() {
        return association;
    }

    /** 
     * Set the 'Association' element value. *** SABRE ADDED *** Information about structure of an Association
     * 
     * @param association
     */
    public void setAssociation(AssociationType association) {
        setChoiceSelect(ASSOCIATION_CHOICE);
        this.association = association;
    }

    /** 
     * Check if Filter is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFilter() {
        return choiceSelect == FILTER_CHOICE;
    }

    /** 
     * Get the 'Filter' element value. *** SABRE ADDED *** Information about structure of a Filter 
     * 
     * @return value
     */
    public FilterType getFilter() {
        return filter;
    }

    /** 
     * Set the 'Filter' element value. *** SABRE ADDED *** Information about structure of a Filter 
     * 
     * @param filter
     */
    public void setFilter(FilterType filter) {
        setChoiceSelect(FILTER_CHOICE);
        this.filter = filter;
    }

    /** 
     * Check if Format is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFormat() {
        return choiceSelect == FORMAT_CHOICE;
    }

    /** 
     * Get the 'Format' element value. *** SABRE ADDED *** Information about structure of a Format 
     * 
     * @return value
     */
    public FormatType getFormat() {
        return format;
    }

    /** 
     * Set the 'Format' element value. *** SABRE ADDED *** Information about structure of a Format 
     * 
     * @param format
     */
    public void setFormat(FormatType format) {
        setChoiceSelect(FORMAT_CHOICE);
        this.format = format;
    }

    /** 
     * Check if Configuration is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifConfiguration() {
        return choiceSelect == CONFIGURATION_CHOICE;
    }

    /** 
     * Get the 'Configuration' element value. *** SABRE ADDED *** Information about Configuration Storage Object 
     * 
     * @return value
     */
    public ConfigurationType getConfiguration() {
        return configuration;
    }

    /** 
     * Set the 'Configuration' element value. *** SABRE ADDED *** Information about Configuration Storage Object 
     * 
     * @param configuration
     */
    public void setConfiguration(ConfigurationType configuration) {
        setChoiceSelect(CONFIGURATION_CHOICE);
        this.configuration = configuration;
    }

    /** 
     * Get the 'CreateAccessInfo' element value.
     * 
     * @return value
     */
    public AccessInfoType getCreateAccessInfo() {
        return createAccessInfo;
    }

    /** 
     * Set the 'CreateAccessInfo' element value.
     * 
     * @param createAccessInfo
     */
    public void setCreateAccessInfo(AccessInfoType createAccessInfo) {
        this.createAccessInfo = createAccessInfo;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'IgnoreDataErrors' attribute value. If set to true then data errors will be ingored and only subject areas without any erorrs will be stored. If it is set to N or U or not used then the profile will be saved only if all the subject areas are good
     * 
     * @return value
     */
    public YesNoType getIgnoreDataErrors() {
        return ignoreDataErrors;
    }

    /** 
     * Set the 'IgnoreDataErrors' attribute value. If set to true then data errors will be ingored and only subject areas without any erorrs will be stored. If it is set to N or U or not used then the profile will be saved only if all the subject areas are good
     * 
     * @param ignoreDataErrors
     */
    public void setIgnoreDataErrors(YesNoType ignoreDataErrors) {
        this.ignoreDataErrors = ignoreDataErrors;
    }

    /** 
     * Get the 'UpdateByDataSourceInfo' attribute value. If set to true then only subject areas identified with Primary data source info will be updated
     * 
     * @return value
     */
    public YesNoType getUpdateByDataSourceInfo() {
        return updateByDataSourceInfo;
    }

    /** 
     * Set the 'UpdateByDataSourceInfo' attribute value. If set to true then only subject areas identified with Primary data source info will be updated
     * 
     * @param updateByDataSourceInfo
     */
    public void setUpdateByDataSourceInfo(YesNoType updateByDataSourceInfo) {
        this.updateByDataSourceInfo = updateByDataSourceInfo;
    }

    /** 
     * Get the 'ProfileDuplicateCheck' attribute value. If set then Duplicate check will be performed on profiles before creatinga profile 
     * 
     * @return value
     */
    public YesNoType getProfileDuplicateCheck() {
        return profileDuplicateCheck;
    }

    /** 
     * Set the 'ProfileDuplicateCheck' attribute value. If set then Duplicate check will be performed on profiles before creatinga profile 
     * 
     * @param profileDuplicateCheck
     */
    public void setProfileDuplicateCheck(YesNoType profileDuplicateCheck) {
        this.profileDuplicateCheck = profileDuplicateCheck;
    }

    /** 
     * Get the 'GenerateLoginID' attribute value. If set then LoginID will be set based on airline configuration 
     * 
     * @return value
     */
    public YesNoType getGenerateLoginID() {
        return generateLoginID;
    }

    /** 
     * Set the 'GenerateLoginID' attribute value. If set then LoginID will be set based on airline configuration 
     * 
     * @param generateLoginID
     */
    public void setGenerateLoginID(YesNoType generateLoginID) {
        this.generateLoginID = generateLoginID;
    }

    /** 
     * Get the 'GeneratePassword' attribute value. If set then Password will be set based on airline configuration 
     * 
     * @return value
     */
    public YesNoType getGeneratePassword() {
        return generatePassword;
    }

    /** 
     * Set the 'GeneratePassword' attribute value. If set then Password will be set based on airline configuration 
     * 
     * @param generatePassword
     */
    public void setGeneratePassword(YesNoType generatePassword) {
        this.generatePassword = generatePassword;
    }

    /** 
     * Get the 'GenerateMembershipID' attribute value. If set then Password will be set based on airline configuration 
     * 
     * @return value
     */
    public YesNoType getGenerateMembershipID() {
        return generateMembershipID;
    }

    /** 
     * Set the 'GenerateMembershipID' attribute value. If set then Password will be set based on airline configuration 
     * 
     * @param generateMembershipID
     */
    public void setGenerateMembershipID(YesNoType generateMembershipID) {
        this.generateMembershipID = generateMembershipID;
    }

    /** 
     * Get the 'IgnoreStatusCheck' attribute value. If set to Y, profile status (e.g. AC, IN, DL, ...) will not be validated. All statues in request will be accepted
     * 
     * @return value
     */
    public YesNoType getIgnoreStatusCheck() {
        return ignoreStatusCheck;
    }

    /** 
     * Set the 'IgnoreStatusCheck' attribute value. If set to Y, profile status (e.g. AC, IN, DL, ...) will not be validated. All statues in request will be accepted
     * 
     * @param ignoreStatusCheck
     */
    public void setIgnoreStatusCheck(YesNoType ignoreStatusCheck) {
        this.ignoreStatusCheck = ignoreStatusCheck;
    }

    /** 
     * Get the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @return value
     */
    public String getRequestTrackingID() {
        return requestTrackingID;
    }

    /** 
     * Set the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @param requestTrackingID
     */
    public void setRequestTrackingID(String requestTrackingID) {
        this.requestTrackingID = requestTrackingID;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
