
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 *  Read request for Profile

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileReadRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:choice>
 *         &lt;xs:element type="ns:ReadProfileType" name="Profile"/>
 *         &lt;xs:element type="ns:ReadTemplateType" name="Template"/>
 *         &lt;xs:element type="ns:ReadMetadataType" name="Metadata"/>
 *         &lt;xs:element type="ns:ReadValidatorType" name="Validator"/>
 *         &lt;xs:element type="ns:ReadAssociationType" name="Association"/>
 *         &lt;xs:element type="ns:ReadFilterType" name="Filter"/>
 *         &lt;xs:element type="ns:ReadFormatType" name="Format"/>
 *         &lt;xs:element type="ns:ReadProfilesType" name="Profiles"/>
 *       &lt;/xs:choice>
 *       &lt;xs:element type="ns:AccessInfoType" name="ReadAccessInfo" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="RequestTrackingID"/>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *     &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="ReturnAuditInfo"/>
 *     &lt;xs:attribute type="xs:int" use="optional" name="AuditInfoItemCount"/>
 *     &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="IgnoreStatusCheck"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileReadRQ implements Serializable
{
    private int choiceSelect = -1;
    private static final int PROFILE_CHOICE = 0;
    private static final int TEMPLATE_CHOICE = 1;
    private static final int METADATA_CHOICE = 2;
    private static final int VALIDATOR_CHOICE = 3;
    private static final int ASSOCIATION_CHOICE = 4;
    private static final int FILTER_CHOICE = 5;
    private static final int FORMAT_CHOICE = 6;
    private static final int PROFILES_CHOICE = 7;
    private ReadProfileType profile;
    private ReadTemplateType template;
    private ReadMetadataType metadata;
    private ReadValidatorType validator;
    private ReadAssociationType association;
    private ReadFilterType filter;
    private ReadFormatType format;
    private ReadProfilesType profiles;
    private AccessInfoType readAccessInfo;
    private String requestTrackingID;
    private Date timeStamp;
    private Target target;
    private String version;
    private YesNoType returnAuditInfo;
    private Integer auditInfoItemCount;
    private YesNoType ignoreStatusCheck;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Profile is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfile() {
        return choiceSelect == PROFILE_CHOICE;
    }

    /** 
     * Get the 'Profile' element value.
     * 
     * @return value
     */
    public ReadProfileType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value.
     * 
     * @param profile
     */
    public void setProfile(ReadProfileType profile) {
        setChoiceSelect(PROFILE_CHOICE);
        this.profile = profile;
    }

    /** 
     * Check if Template is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTemplate() {
        return choiceSelect == TEMPLATE_CHOICE;
    }

    /** 
     * Get the 'Template' element value. *** SABRE ADDED *** Information about structure of a template
     * 
     * @return value
     */
    public ReadTemplateType getTemplate() {
        return template;
    }

    /** 
     * Set the 'Template' element value. *** SABRE ADDED *** Information about structure of a template
     * 
     * @param template
     */
    public void setTemplate(ReadTemplateType template) {
        setChoiceSelect(TEMPLATE_CHOICE);
        this.template = template;
    }

    /** 
     * Check if Metadata is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifMetadata() {
        return choiceSelect == METADATA_CHOICE;
    }

    /** 
     * Get the 'Metadata' element value. Information about structure of a Metadata 
     * 
     * @return value
     */
    public ReadMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Information about structure of a Metadata 
     * 
     * @param metadata
     */
    public void setMetadata(ReadMetadataType metadata) {
        setChoiceSelect(METADATA_CHOICE);
        this.metadata = metadata;
    }

    /** 
     * Check if Validator is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifValidator() {
        return choiceSelect == VALIDATOR_CHOICE;
    }

    /** 
     * Get the 'Validator' element value. Information about structure of a Validator
     * 
     * @return value
     */
    public ReadValidatorType getValidator() {
        return validator;
    }

    /** 
     * Set the 'Validator' element value. Information about structure of a Validator
     * 
     * @param validator
     */
    public void setValidator(ReadValidatorType validator) {
        setChoiceSelect(VALIDATOR_CHOICE);
        this.validator = validator;
    }

    /** 
     * Check if Association is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAssociation() {
        return choiceSelect == ASSOCIATION_CHOICE;
    }

    /** 
     * Get the 'Association' element value. Information about structure of an Association
     * 
     * @return value
     */
    public ReadAssociationType getAssociation() {
        return association;
    }

    /** 
     * Set the 'Association' element value. Information about structure of an Association
     * 
     * @param association
     */
    public void setAssociation(ReadAssociationType association) {
        setChoiceSelect(ASSOCIATION_CHOICE);
        this.association = association;
    }

    /** 
     * Check if Filter is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFilter() {
        return choiceSelect == FILTER_CHOICE;
    }

    /** 
     * Get the 'Filter' element value. *** SABRE ADDED *** Information about structure of a Filter 
     * 
     * @return value
     */
    public ReadFilterType getFilter() {
        return filter;
    }

    /** 
     * Set the 'Filter' element value. *** SABRE ADDED *** Information about structure of a Filter 
     * 
     * @param filter
     */
    public void setFilter(ReadFilterType filter) {
        setChoiceSelect(FILTER_CHOICE);
        this.filter = filter;
    }

    /** 
     * Check if Format is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFormat() {
        return choiceSelect == FORMAT_CHOICE;
    }

    /** 
     * Get the 'Format' element value. *** SABRE ADDED *** Information about structure of a Format 
     * 
     * @return value
     */
    public ReadFormatType getFormat() {
        return format;
    }

    /** 
     * Set the 'Format' element value. *** SABRE ADDED *** Information about structure of a Format 
     * 
     * @param format
     */
    public void setFormat(ReadFormatType format) {
        setChoiceSelect(FORMAT_CHOICE);
        this.format = format;
    }

    /** 
     * Check if Profiles is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifProfiles() {
        return choiceSelect == PROFILES_CHOICE;
    }

    /** 
     * Get the 'Profiles' element value.
     * 
     * @return value
     */
    public ReadProfilesType getProfiles() {
        return profiles;
    }

    /** 
     * Set the 'Profiles' element value.
     * 
     * @param profiles
     */
    public void setProfiles(ReadProfilesType profiles) {
        setChoiceSelect(PROFILES_CHOICE);
        this.profiles = profiles;
    }

    /** 
     * Get the 'ReadAccessInfo' element value.
     * 
     * @return value
     */
    public AccessInfoType getReadAccessInfo() {
        return readAccessInfo;
    }

    /** 
     * Set the 'ReadAccessInfo' element value.
     * 
     * @param readAccessInfo
     */
    public void setReadAccessInfo(AccessInfoType readAccessInfo) {
        this.readAccessInfo = readAccessInfo;
    }

    /** 
     * Get the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @return value
     */
    public String getRequestTrackingID() {
        return requestTrackingID;
    }

    /** 
     * Set the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @param requestTrackingID
     */
    public void setRequestTrackingID(String requestTrackingID) {
        this.requestTrackingID = requestTrackingID;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'ReturnAuditInfo' attribute value. Indicates if return Profile audit info
     * 
     * @return value
     */
    public YesNoType getReturnAuditInfo() {
        return returnAuditInfo;
    }

    /** 
     * Set the 'ReturnAuditInfo' attribute value. Indicates if return Profile audit info
     * 
     * @param returnAuditInfo
     */
    public void setReturnAuditInfo(YesNoType returnAuditInfo) {
        this.returnAuditInfo = returnAuditInfo;
    }

    /** 
     * Get the 'AuditInfoItemCount' attribute value. Set maximum number of returned audit info data
     * 
     * @return value
     */
    public Integer getAuditInfoItemCount() {
        return auditInfoItemCount;
    }

    /** 
     * Set the 'AuditInfoItemCount' attribute value. Set maximum number of returned audit info data
     * 
     * @param auditInfoItemCount
     */
    public void setAuditInfoItemCount(Integer auditInfoItemCount) {
        this.auditInfoItemCount = auditInfoItemCount;
    }

    /** 
     * Get the 'IgnoreStatusCheck' attribute value. If set to Y, profile status (e.g. AC, IN, DL, ...) will not be validated. All profiles could be read.
     * 
     * @return value
     */
    public YesNoType getIgnoreStatusCheck() {
        return ignoreStatusCheck;
    }

    /** 
     * Set the 'IgnoreStatusCheck' attribute value. If set to Y, profile status (e.g. AC, IN, DL, ...) will not be validated. All profiles could be read.
     * 
     * @param ignoreStatusCheck
     */
    public void setIgnoreStatusCheck(YesNoType ignoreStatusCheck) {
        this.ignoreStatusCheck = ignoreStatusCheck;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
