
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Returns a single or multiple customer profile(s) in response to a ReadRQ request of Type=Profile.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileReadRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:ResponseMessageType" name="ResponseMessage"/>
 *       &lt;xs:choice minOccurs="0">
 *         &lt;!-- Reference to inner class Choice -->
 *       &lt;/xs:choice>
 *       &lt;xs:element type="ns:ProfileAccessInfoType" name="AuditInfo" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="RequestTrackingID"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileReadRS implements Serializable
{
    private ResponseMessageType responseMessage;
    private Choice choice;
    private ProfileAccessInfoType auditInfo;
    private Date timeStamp;
    private Target target;
    private String version;
    private String requestTrackingID;

    /** 
     * Get the 'ResponseMessage' element value. *** SABRE ADDED *** Response Messages
     * 
     * @return value
     */
    public ResponseMessageType getResponseMessage() {
        return responseMessage;
    }

    /** 
     * Set the 'ResponseMessage' element value. *** SABRE ADDED *** Response Messages
     * 
     * @param responseMessage
     */
    public void setResponseMessage(ResponseMessageType responseMessage) {
        this.responseMessage = responseMessage;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'AuditInfo' element value. Profile access audit information
     * 
     * @return value
     */
    public ProfileAccessInfoType getAuditInfo() {
        return auditInfo;
    }

    /** 
     * Set the 'AuditInfo' element value. Profile access audit information
     * 
     * @param auditInfo
     */
    public void setAuditInfo(ProfileAccessInfoType auditInfo) {
        this.auditInfo = auditInfo;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @return value
     */
    public String getRequestTrackingID() {
        return requestTrackingID;
    }

    /** 
     * Set the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @param requestTrackingID
     */
    public void setRequestTrackingID(String requestTrackingID) {
        this.requestTrackingID = requestTrackingID;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="xs:string" name="Message"/>
     *   &lt;xs:element type="ns:ProfileType" name="Profile"/>
     *   &lt;xs:element type="ns:TemplateType" name="Template"/>
     *   &lt;xs:element type="ns:FilterType" name="Filter"/>
     *   &lt;xs:element type="ns:FormatType" name="Format"/>
     *   &lt;xs:element type="ns:ReadRSProfilesType" name="Profiles"/>
     *   &lt;xs:element type="ns:AssociationType" name="Association"/>
     *   &lt;xs:element type="ns:MetadataType" name="Metadata"/>
     *   &lt;xs:element type="ns:ValidatorType" name="Validator"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int MESSAGE_CHOICE = 0;
        private static final int PROFILE_CHOICE = 1;
        private static final int TEMPLATE_CHOICE = 2;
        private static final int FILTER_CHOICE = 3;
        private static final int FORMAT_CHOICE = 4;
        private static final int PROFILES_CHOICE = 5;
        private static final int ASSOCIATION_CHOICE = 6;
        private static final int METADATA_CHOICE = 7;
        private static final int VALIDATOR_CHOICE = 8;
        private String message;
        private ProfileType profile;
        private TemplateType template;
        private FilterType filter;
        private FormatType format;
        private ReadRSProfilesType profiles;
        private AssociationType association;
        private MetadataType metadata;
        private ValidatorType validator;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Message is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMessage() {
            return choiceSelect == MESSAGE_CHOICE;
        }

        /** 
         * Get the 'Message' element value. *** SABRE ADDED *** Message
         * 
         * @return value
         */
        public String getMessage() {
            return message;
        }

        /** 
         * Set the 'Message' element value. *** SABRE ADDED *** Message
         * 
         * @param message
         */
        public void setMessage(String message) {
            setChoiceSelect(MESSAGE_CHOICE);
            this.message = message;
        }

        /** 
         * Check if Profile is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifProfile() {
            return choiceSelect == PROFILE_CHOICE;
        }

        /** 
         * Get the 'Profile' element value. *** OTA Based *** If name search finds more than one profile choose VITProfiles
         * 
         * @return value
         */
        public ProfileType getProfile() {
            return profile;
        }

        /** 
         * Set the 'Profile' element value. *** OTA Based *** If name search finds more than one profile choose VITProfiles
         * 
         * @param profile
         */
        public void setProfile(ProfileType profile) {
            setChoiceSelect(PROFILE_CHOICE);
            this.profile = profile;
        }

        /** 
         * Check if Template is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTemplate() {
            return choiceSelect == TEMPLATE_CHOICE;
        }

        /** 
         * Get the 'Template' element value. *** SABRE ADDED *** Information about structure of a template
         * 
         * @return value
         */
        public TemplateType getTemplate() {
            return template;
        }

        /** 
         * Set the 'Template' element value. *** SABRE ADDED *** Information about structure of a template
         * 
         * @param template
         */
        public void setTemplate(TemplateType template) {
            setChoiceSelect(TEMPLATE_CHOICE);
            this.template = template;
        }

        /** 
         * Check if Filter is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifFilter() {
            return choiceSelect == FILTER_CHOICE;
        }

        /** 
         * Get the 'Filter' element value. *** SABRE ADDED *** Information about structure of a Filter 
         * 
         * @return value
         */
        public FilterType getFilter() {
            return filter;
        }

        /** 
         * Set the 'Filter' element value. *** SABRE ADDED *** Information about structure of a Filter 
         * 
         * @param filter
         */
        public void setFilter(FilterType filter) {
            setChoiceSelect(FILTER_CHOICE);
            this.filter = filter;
        }

        /** 
         * Check if Format is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifFormat() {
            return choiceSelect == FORMAT_CHOICE;
        }

        /** 
         * Get the 'Format' element value. *** SABRE ADDED *** Information about structure of a Format 
         * 
         * @return value
         */
        public FormatType getFormat() {
            return format;
        }

        /** 
         * Set the 'Format' element value. *** SABRE ADDED *** Information about structure of a Format 
         * 
         * @param format
         */
        public void setFormat(FormatType format) {
            setChoiceSelect(FORMAT_CHOICE);
            this.format = format;
        }

        /** 
         * Check if Profiles is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifProfiles() {
            return choiceSelect == PROFILES_CHOICE;
        }

        /** 
         * Get the 'Profiles' element value. *** OTA Based *** If name search finds more than one profile choose VITProfiles
         * 
         * @return value
         */
        public ReadRSProfilesType getProfiles() {
            return profiles;
        }

        /** 
         * Set the 'Profiles' element value. *** OTA Based *** If name search finds more than one profile choose VITProfiles
         * 
         * @param profiles
         */
        public void setProfiles(ReadRSProfilesType profiles) {
            setChoiceSelect(PROFILES_CHOICE);
            this.profiles = profiles;
        }

        /** 
         * Check if Association is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAssociation() {
            return choiceSelect == ASSOCIATION_CHOICE;
        }

        /** 
         * Get the 'Association' element value. *** SABRE ADDED *** Information about Association
         * 
         * @return value
         */
        public AssociationType getAssociation() {
            return association;
        }

        /** 
         * Set the 'Association' element value. *** SABRE ADDED *** Information about Association
         * 
         * @param association
         */
        public void setAssociation(AssociationType association) {
            setChoiceSelect(ASSOCIATION_CHOICE);
            this.association = association;
        }

        /** 
         * Check if Metadata is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMetadata() {
            return choiceSelect == METADATA_CHOICE;
        }

        /** 
         * Get the 'Metadata' element value. *** SABRE ADDED *** Information about structure of a Metadata
         * 
         * @return value
         */
        public MetadataType getMetadata() {
            return metadata;
        }

        /** 
         * Set the 'Metadata' element value. *** SABRE ADDED *** Information about structure of a Metadata
         * 
         * @param metadata
         */
        public void setMetadata(MetadataType metadata) {
            setChoiceSelect(METADATA_CHOICE);
            this.metadata = metadata;
        }

        /** 
         * Check if Validator is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifValidator() {
            return choiceSelect == VALIDATOR_CHOICE;
        }

        /** 
         * Get the 'Validator' element value. *** SABRE ADDED *** Information about structure of a Validator
         * 
         * @return value
         */
        public ValidatorType getValidator() {
            return validator;
        }

        /** 
         * Set the 'Validator' element value. *** SABRE ADDED *** Information about structure of a Validator
         * 
         * @param validator
         */
        public void setValidator(ValidatorType validator) {
            setChoiceSelect(VALIDATOR_CHOICE);
            this.validator = validator;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
