
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Response to Sabre_OTA_ProfileSearchRQ
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Sabre_OTA_ProfileSearchRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:ResponseMessageType" name="ResponseMessage"/>
 *       &lt;xs:choice minOccurs="0">
 *         &lt;!-- Reference to inner class Choice -->
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:dateTime" use="optional" name="TimeStamp"/>
 *     &lt;xs:attribute use="optional" default="Production" name="Target">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Target -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:attribute>
 *     &lt;xs:attribute type="xs:string" use="required" name="Version"/>
 *     &lt;xs:attribute type="xs:string" use="optional" name="RequestTrackingID"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class SabreOTAProfileSearchRS implements Serializable
{
    private ResponseMessageType responseMessage;
    private Choice choice;
    private Date timeStamp;
    private Target target;
    private String version;
    private String requestTrackingID;

    /** 
     * Get the 'ResponseMessage' element value. *** SABRE ADDED *** Response Messages
     * 
     * @return value
     */
    public ResponseMessageType getResponseMessage() {
        return responseMessage;
    }

    /** 
     * Set the 'ResponseMessage' element value. *** SABRE ADDED *** Response Messages
     * 
     * @param responseMessage
     */
    public void setResponseMessage(ResponseMessageType responseMessage) {
        this.responseMessage = responseMessage;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' attribute value. Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes 2003-11-20T13:59:38Z).
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @return value
     */
    public Target getTarget() {
        return target;
    }

    /** 
     * Set the 'Target' attribute value. Used to indicate whether the request is for the Test or Production system.
     * 
     * @param target
     */
    public void setTarget(Target target) {
        this.target = target;
    }

    /** 
     * Get the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value. For all OTA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @return value
     */
    public String getRequestTrackingID() {
        return requestTrackingID;
    }

    /** 
     * Set the 'RequestTrackingID' attribute value. RequestTrackingID is indicated by string value
     * 
     * @param requestTrackingID
     */
    public void setRequestTrackingID(String requestTrackingID) {
        this.requestTrackingID = requestTrackingID;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:SearchRSProfileInfoType" name="ProfileInfo" minOccurs="0"/>
     *   &lt;xs:element type="xs:string" name="ProfileCount"/>
     *   &lt;xs:element type="ns:SearchRSTemplateInfoType" name="TemplateInfo" minOccurs="0"/>
     *   &lt;xs:element type="xs:string" name="TemplateCount"/>
     *   &lt;xs:element type="ns:SearchRSAssociationInfoType" name="AssociationInfo" minOccurs="0"/>
     *   &lt;xs:element type="ns:SearchRSFilterInfoType" name="FilterInfo" minOccurs="0"/>
     *   &lt;xs:element type="ns:SearchRSFormatInfoType" name="FormatInfo" minOccurs="0"/>
     *   &lt;xs:element type="ns:SearchRSValidatorInfoType" name="ValidatorInfo" minOccurs="0"/>
     *   &lt;xs:element type="ns:SearchRSMetadataInfoType" name="MetadataInfo" minOccurs="0"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int PROFILE_INFO_CHOICE = 0;
        private static final int PROFILE_COUNT_CHOICE = 1;
        private static final int TEMPLATE_INFO_CHOICE = 2;
        private static final int TEMPLATE_COUNT_CHOICE = 3;
        private static final int ASSOCIATION_INFO_CHOICE = 4;
        private static final int FILTER_INFO_CHOICE = 5;
        private static final int FORMAT_INFO_CHOICE = 6;
        private static final int VALIDATOR_INFO_CHOICE = 7;
        private static final int METADATA_INFO_CHOICE = 8;
        private SearchRSProfileInfoType profileInfo;
        private String profileCount;
        private SearchRSTemplateInfoType templateInfo;
        private String templateCount;
        private SearchRSAssociationInfoType associationInfo;
        private SearchRSFilterInfoType filterInfo;
        private SearchRSFormatInfoType formatInfo;
        private SearchRSValidatorInfoType validatorInfo;
        private SearchRSMetadataInfoType metadataInfo;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if ProfileInfo is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifProfileInfo() {
            return choiceSelect == PROFILE_INFO_CHOICE;
        }

        /** 
         * Get the 'ProfileInfo' element value. *** SABRE ADDED *** Response for Profile Search request
         * 
         * @return value
         */
        public SearchRSProfileInfoType getProfileInfo() {
            return profileInfo;
        }

        /** 
         * Set the 'ProfileInfo' element value. *** SABRE ADDED *** Response for Profile Search request
         * 
         * @param profileInfo
         */
        public void setProfileInfo(SearchRSProfileInfoType profileInfo) {
            setChoiceSelect(PROFILE_INFO_CHOICE);
            this.profileInfo = profileInfo;
        }

        /** 
         * Check if ProfileCount is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifProfileCount() {
            return choiceSelect == PROFILE_COUNT_CHOICE;
        }

        /** 
         * Get the 'ProfileCount' element value. *** Depricated ***
         * 
         * @return value
         */
        public String getProfileCount() {
            return profileCount;
        }

        /** 
         * Set the 'ProfileCount' element value. *** Depricated ***
         * 
         * @param profileCount
         */
        public void setProfileCount(String profileCount) {
            setChoiceSelect(PROFILE_COUNT_CHOICE);
            this.profileCount = profileCount;
        }

        /** 
         * Check if TemplateInfo is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTemplateInfo() {
            return choiceSelect == TEMPLATE_INFO_CHOICE;
        }

        /** 
         * Get the 'TemplateInfo' element value. *** SABRE ADDED *** Response for Template Search request
         * 
         * @return value
         */
        public SearchRSTemplateInfoType getTemplateInfo() {
            return templateInfo;
        }

        /** 
         * Set the 'TemplateInfo' element value. *** SABRE ADDED *** Response for Template Search request
         * 
         * @param templateInfo
         */
        public void setTemplateInfo(SearchRSTemplateInfoType templateInfo) {
            setChoiceSelect(TEMPLATE_INFO_CHOICE);
            this.templateInfo = templateInfo;
        }

        /** 
         * Check if TemplateCount is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTemplateCount() {
            return choiceSelect == TEMPLATE_COUNT_CHOICE;
        }

        /** 
         * Get the 'TemplateCount' element value. *** SABRE ADDED *** Response for Template Count request
         * 
         * @return value
         */
        public String getTemplateCount() {
            return templateCount;
        }

        /** 
         * Set the 'TemplateCount' element value. *** SABRE ADDED *** Response for Template Count request
         * 
         * @param templateCount
         */
        public void setTemplateCount(String templateCount) {
            setChoiceSelect(TEMPLATE_COUNT_CHOICE);
            this.templateCount = templateCount;
        }

        /** 
         * Check if AssociationInfo is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAssociationInfo() {
            return choiceSelect == ASSOCIATION_INFO_CHOICE;
        }

        /** 
         * Get the 'AssociationInfo' element value. *** SABRE ADDED *** Response for Association Search request
         * 
         * @return value
         */
        public SearchRSAssociationInfoType getAssociationInfo() {
            return associationInfo;
        }

        /** 
         * Set the 'AssociationInfo' element value. *** SABRE ADDED *** Response for Association Search request
         * 
         * @param associationInfo
         */
        public void setAssociationInfo(
                SearchRSAssociationInfoType associationInfo) {
            setChoiceSelect(ASSOCIATION_INFO_CHOICE);
            this.associationInfo = associationInfo;
        }

        /** 
         * Check if FilterInfo is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifFilterInfo() {
            return choiceSelect == FILTER_INFO_CHOICE;
        }

        /** 
         * Get the 'FilterInfo' element value. *** SABRE ADDED *** Response for Filter Search request
         * 
         * @return value
         */
        public SearchRSFilterInfoType getFilterInfo() {
            return filterInfo;
        }

        /** 
         * Set the 'FilterInfo' element value. *** SABRE ADDED *** Response for Filter Search request
         * 
         * @param filterInfo
         */
        public void setFilterInfo(SearchRSFilterInfoType filterInfo) {
            setChoiceSelect(FILTER_INFO_CHOICE);
            this.filterInfo = filterInfo;
        }

        /** 
         * Check if FormatInfo is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifFormatInfo() {
            return choiceSelect == FORMAT_INFO_CHOICE;
        }

        /** 
         * Get the 'FormatInfo' element value. *** SABRE ADDED *** Response for Format Search request
         * 
         * @return value
         */
        public SearchRSFormatInfoType getFormatInfo() {
            return formatInfo;
        }

        /** 
         * Set the 'FormatInfo' element value. *** SABRE ADDED *** Response for Format Search request
         * 
         * @param formatInfo
         */
        public void setFormatInfo(SearchRSFormatInfoType formatInfo) {
            setChoiceSelect(FORMAT_INFO_CHOICE);
            this.formatInfo = formatInfo;
        }

        /** 
         * Check if ValidatorInfo is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifValidatorInfo() {
            return choiceSelect == VALIDATOR_INFO_CHOICE;
        }

        /** 
         * Get the 'ValidatorInfo' element value. *** SABRE ADDED *** Response for Validator Search request
         * 
         * @return value
         */
        public SearchRSValidatorInfoType getValidatorInfo() {
            return validatorInfo;
        }

        /** 
         * Set the 'ValidatorInfo' element value. *** SABRE ADDED *** Response for Validator Search request
         * 
         * @param validatorInfo
         */
        public void setValidatorInfo(SearchRSValidatorInfoType validatorInfo) {
            setChoiceSelect(VALIDATOR_INFO_CHOICE);
            this.validatorInfo = validatorInfo;
        }

        /** 
         * Check if MetadataInfo is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMetadataInfo() {
            return choiceSelect == METADATA_INFO_CHOICE;
        }

        /** 
         * Get the 'MetadataInfo' element value. *** SABRE ADDED *** Response for Metadata Search request
         * 
         * @return value
         */
        public SearchRSMetadataInfoType getMetadataInfo() {
            return metadataInfo;
        }

        /** 
         * Set the 'MetadataInfo' element value. *** SABRE ADDED *** Response for Metadata Search request
         * 
         * @param metadataInfo
         */
        public void setMetadataInfo(SearchRSMetadataInfoType metadataInfo) {
            setChoiceSelect(METADATA_INFO_CHOICE);
            this.metadataInfo = metadataInfo;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Test"/>
     *     &lt;xs:enumeration value="Production"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Target implements Serializable {
        TEST("Test"), PRODUCTION("Production");
        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Target convert(String value) {
            for (Target inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
