
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Sabre Travel Policy Policies Information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SabreTravelPolicyEngineType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="PolicyID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="PolicyName"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SabreTravelPolicyEngineType implements Serializable
{
    private TransactionalDataType transactionalData;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String policyID;
    private String policyName;

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value.
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value.
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'PolicyID' attribute value. TPE Policy ID
     * 
     * @return value
     */
    public String getPolicyID() {
        return policyID;
    }

    /** 
     * Set the 'PolicyID' attribute value. TPE Policy ID
     * 
     * @param policyID
     */
    public void setPolicyID(String policyID) {
        this.policyID = policyID;
    }

    /** 
     * Get the 'PolicyName' attribute value. TPE Policy Name
     * 
     * @return value
     */
    public String getPolicyName() {
        return policyName;
    }

    /** 
     * Set the 'PolicyName' attribute value. TPE Policy Name
     * 
     * @param policyName
     */
    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }
}
