
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Profiles Associated to a Profile
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchAssociatedProfilesType">
 *   &lt;xs:attribute type="ns:SearchProfileTypeInfo" use="optional" name="AssocProfileType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AssocProfileName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AssocUniqueID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DomainID"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="CreditBankIndicator"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProfileRelationTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProfileRelationStatusCode"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="IncludeTemplateAssoc"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchAssociatedProfilesType implements Serializable
{
    private SearchProfileTypeInfo assocProfileType;
    private String assocProfileName;
    private String assocUniqueID;
    private String domainID;
    private YesNoType creditBankIndicator;
    private String profileRelationTypeCode;
    private String profileRelationStatusCode;
    private YesNoType includeTemplateAssoc;

    /** 
     * Get the 'AssocProfileType' attribute value. *** SABRE ADDED *** Associated Profile Type
     * 
     * @return value
     */
    public SearchProfileTypeInfo getAssocProfileType() {
        return assocProfileType;
    }

    /** 
     * Set the 'AssocProfileType' attribute value. *** SABRE ADDED *** Associated Profile Type
     * 
     * @param assocProfileType
     */
    public void setAssocProfileType(SearchProfileTypeInfo assocProfileType) {
        this.assocProfileType = assocProfileType;
    }

    /** 
     * Get the 'AssocProfileName' attribute value.
     * 
     * @return value
     */
    public String getAssocProfileName() {
        return assocProfileName;
    }

    /** 
     * Set the 'AssocProfileName' attribute value.
     * 
     * @param assocProfileName
     */
    public void setAssocProfileName(String assocProfileName) {
        this.assocProfileName = assocProfileName;
    }

    /** 
     * Get the 'AssocUniqueID' attribute value. *** SABRE ADDED *** Associate profileID
     * 
     * @return value
     */
    public String getAssocUniqueID() {
        return assocUniqueID;
    }

    /** 
     * Set the 'AssocUniqueID' attribute value. *** SABRE ADDED *** Associate profileID
     * 
     * @param assocUniqueID
     */
    public void setAssocUniqueID(String assocUniqueID) {
        this.assocUniqueID = assocUniqueID;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'CreditBankIndicator' attribute value. Indicates If Credit Bank is present
    	
     * 
     * @return value
     */
    public YesNoType getCreditBankIndicator() {
        return creditBankIndicator;
    }

    /** 
     * Set the 'CreditBankIndicator' attribute value. Indicates If Credit Bank is present
    	
     * 
     * @param creditBankIndicator
     */
    public void setCreditBankIndicator(YesNoType creditBankIndicator) {
        this.creditBankIndicator = creditBankIndicator;
    }

    /** 
     * Get the 'ProfileRelationTypeCode' attribute value. Indicates Type of relationship between profiles
    	
     * 
     * @return value
     */
    public String getProfileRelationTypeCode() {
        return profileRelationTypeCode;
    }

    /** 
     * Set the 'ProfileRelationTypeCode' attribute value. Indicates Type of relationship between profiles
    	
     * 
     * @param profileRelationTypeCode
     */
    public void setProfileRelationTypeCode(String profileRelationTypeCode) {
        this.profileRelationTypeCode = profileRelationTypeCode;
    }

    /** 
     * Get the 'ProfileRelationStatusCode' attribute value. Indicates Status of relationship between
    	
     * 
     * @return value
     */
    public String getProfileRelationStatusCode() {
        return profileRelationStatusCode;
    }

    /** 
     * Set the 'ProfileRelationStatusCode' attribute value. Indicates Status of relationship between
    	
     * 
     * @param profileRelationStatusCode
     */
    public void setProfileRelationStatusCode(String profileRelationStatusCode) {
        this.profileRelationStatusCode = profileRelationStatusCode;
    }

    /** 
     * Get the 'IncludeTemplateAssoc' attribute value. 
    				Takes effect only when "AssociatedProfiles" section is present in SearchRQ.
    				Y - search both, template-level and profile-level associations
    				N - search for profile-level associations only
    			
     * 
     * @return value
     */
    public YesNoType getIncludeTemplateAssoc() {
        return includeTemplateAssoc;
    }

    /** 
     * Set the 'IncludeTemplateAssoc' attribute value. 
    				Takes effect only when "AssociatedProfiles" section is present in SearchRQ.
    				Y - search both, template-level and profile-level associations
    				N - search for profile-level associations only
    			
     * 
     * @param includeTemplateAssoc
     */
    public void setIncludeTemplateAssoc(YesNoType includeTemplateAssoc) {
        this.includeTemplateAssoc = includeTemplateAssoc;
    }
}
