
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Root element for Format content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchFormatIdentityType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:FormatIdentityType">
 *       &lt;xs:attribute type="xs:string" use="required" name="FormatType"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="FormatTypeSuffix"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchFormatIdentityType extends FormatIdentityType implements
    Serializable
{
    private String formatType;
    private String formatTypeSuffix;

    /** 
     * Get the 'FormatType' attribute value.
     * 
     * @return value
     */
    public String getFormatType() {
        return formatType;
    }

    /** 
     * Set the 'FormatType' attribute value.
     * 
     * @param formatType
     */
    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    /** 
     * Get the 'FormatTypeSuffix' attribute value.
     * 
     * @return value
     */
    public String getFormatTypeSuffix() {
        return formatTypeSuffix;
    }

    /** 
     * Set the 'FormatTypeSuffix' attribute value.
     * 
     * @param formatTypeSuffix
     */
    public void setFormatTypeSuffix(String formatTypeSuffix) {
        this.formatTypeSuffix = formatTypeSuffix;
    }
}
