
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchMetadataType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="MetadataID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ProfileTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ClientContextCode"/>
 *   &lt;xs:attribute type="xs:string" name="MetadataName"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchMetadataType implements Serializable
{
    private String metadataID;
    private String domainID;
    private String profileTypeCode;
    private String clientCode;
    private String clientContextCode;
    private String metadataName;

    /** 
     * Get the 'MetadataID' attribute value. *** SABRE ADDED *** ID of Metadata in the database
     * 
     * @return value
     */
    public String getMetadataID() {
        return metadataID;
    }

    /** 
     * Set the 'MetadataID' attribute value. *** SABRE ADDED *** ID of Metadata in the database
     * 
     * @param metadataID
     */
    public void setMetadataID(String metadataID) {
        this.metadataID = metadataID;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ProfileTypeCode' attribute value.
     * 
     * @return value
     */
    public String getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value.
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(String profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'MetadataName' attribute value. Name of the metadata
     * 
     * @return value
     */
    public String getMetadataName() {
        return metadataName;
    }

    /** 
     * Set the 'MetadataName' attribute value. Name of the metadata
     * 
     * @param metadataName
     */
    public void setMetadataName(String metadataName) {
        this.metadataName = metadataName;
    }
}
