
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Agency Arranger Info Data
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchRSAgencyInfoType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="TravelAgencyName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TravelAgencyDescription"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TravelAgencyTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LanguageIDCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TravelAgencyIdentifier"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchRSAgencyInfoType implements Serializable
{
    private String travelAgencyName;
    private String travelAgencyDescription;
    private String travelAgencyTypeCode;
    private String languageIDCode;
    private String travelAgencyIdentifier;

    /** 
     * Get the 'TravelAgencyName' attribute value. Description of the Travel Agency
     * 
     * @return value
     */
    public String getTravelAgencyName() {
        return travelAgencyName;
    }

    /** 
     * Set the 'TravelAgencyName' attribute value. Description of the Travel Agency
     * 
     * @param travelAgencyName
     */
    public void setTravelAgencyName(String travelAgencyName) {
        this.travelAgencyName = travelAgencyName;
    }

    /** 
     * Get the 'TravelAgencyDescription' attribute value. Name of the Travel Agency
     * 
     * @return value
     */
    public String getTravelAgencyDescription() {
        return travelAgencyDescription;
    }

    /** 
     * Set the 'TravelAgencyDescription' attribute value. Name of the Travel Agency
     * 
     * @param travelAgencyDescription
     */
    public void setTravelAgencyDescription(String travelAgencyDescription) {
        this.travelAgencyDescription = travelAgencyDescription;
    }

    /** 
     * Get the 'TravelAgencyTypeCode' attribute value.
     * 
     * @return value
     */
    public String getTravelAgencyTypeCode() {
        return travelAgencyTypeCode;
    }

    /** 
     * Set the 'TravelAgencyTypeCode' attribute value.
     * 
     * @param travelAgencyTypeCode
     */
    public void setTravelAgencyTypeCode(String travelAgencyTypeCode) {
        this.travelAgencyTypeCode = travelAgencyTypeCode;
    }

    /** 
     * Get the 'LanguageIDCode' attribute value.
     * 
     * @return value
     */
    public String getLanguageIDCode() {
        return languageIDCode;
    }

    /** 
     * Set the 'LanguageIDCode' attribute value.
     * 
     * @param languageIDCode
     */
    public void setLanguageIDCode(String languageIDCode) {
        this.languageIDCode = languageIDCode;
    }

    /** 
     * Get the 'TravelAgencyIdentifier' attribute value. "Represents the Travel industry standard, travel agency identification.  This number can either stem from the ARc, IATA or TID.  (Travel Agency Identifier).   ARC is a ""nationally assigned number"", IATA is internationally assigned and TID is assigned if the other 2 are not the source of information for the agency identification.  Usually the prefix distinguishes what type of source it comes from -- there is no requriement for a type code.  Note: this is a ""restricted field"", and can never be ""updated"" in VTO. 
     * 
     * @return value
     */
    public String getTravelAgencyIdentifier() {
        return travelAgencyIdentifier;
    }

    /** 
     * Set the 'TravelAgencyIdentifier' attribute value. "Represents the Travel industry standard, travel agency identification.  This number can either stem from the ARc, IATA or TID.  (Travel Agency Identifier).   ARC is a ""nationally assigned number"", IATA is internationally assigned and TID is assigned if the other 2 are not the source of information for the agency identification.  Usually the prefix distinguishes what type of source it comes from -- there is no requriement for a type code.  Note: this is a ""restricted field"", and can never be ""updated"" in VTO. 
     * 
     * @param travelAgencyIdentifier
     */
    public void setTravelAgencyIdentifier(String travelAgencyIdentifier) {
        this.travelAgencyIdentifier = travelAgencyIdentifier;
    }
}
