
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchRSDocumentType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="DocID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DocTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DocIssueCountryCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchRSDocumentType implements Serializable
{
    private String docID;
    private String docTypeCode;
    private String docIssueCountryCode;

    /** 
     * Get the 'DocID' attribute value. Unique number assigned by authorities to document.
     * 
     * @return value
     */
    public String getDocID() {
        return docID;
    }

    /** 
     * Set the 'DocID' attribute value. Unique number assigned by authorities to document.
     * 
     * @param docID
     */
    public void setDocID(String docID) {
        this.docID = docID;
    }

    /** 
     * Get the 'DocTypeCode' attribute value. Indicates the type of document (e.g. Passport, Military ID, Drivers License, national ID, Vaccination Certificate). Refer to OTA Code List Document Type (DOC).
     * 
     * @return value
     */
    public String getDocTypeCode() {
        return docTypeCode;
    }

    /** 
     * Set the 'DocTypeCode' attribute value. Indicates the type of document (e.g. Passport, Military ID, Drivers License, national ID, Vaccination Certificate). Refer to OTA Code List Document Type (DOC).
     * 
     * @param docTypeCode
     */
    public void setDocTypeCode(String docTypeCode) {
        this.docTypeCode = docTypeCode;
    }

    /** 
     * Get the 'DocIssueCountryCode' attribute value. Country where the document was issued.
     * 
     * @return value
     */
    public String getDocIssueCountryCode() {
        return docIssueCountryCode;
    }

    /** 
     * Set the 'DocIssueCountryCode' attribute value. Country where the document was issued.
     * 
     * @param docIssueCountryCode
     */
    public void setDocIssueCountryCode(String docIssueCountryCode) {
        this.docIssueCountryCode = docIssueCountryCode;
    }
}
