
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Electronic email addresses, in IETF specified format.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchRSEmailType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="EmailTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EmailUsageCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FormatTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="EmailAddress"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PurposeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LanguageIDCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchRSEmailType implements Serializable
{
    private String emailTypeCode;
    private String emailUsageCode;
    private String formatTypeCode;
    private String emailAddress;
    private String purposeCode;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String languageIDCode;

    /** 
     * Get the 'EmailTypeCode' attribute value.
     * 
     * @return value
     */
    public String getEmailTypeCode() {
        return emailTypeCode;
    }

    /** 
     * Set the 'EmailTypeCode' attribute value.
     * 
     * @param emailTypeCode
     */
    public void setEmailTypeCode(String emailTypeCode) {
        this.emailTypeCode = emailTypeCode;
    }

    /** 
     * Get the 'EmailUsageCode' attribute value.
     * 
     * @return value
     */
    public String getEmailUsageCode() {
        return emailUsageCode;
    }

    /** 
     * Set the 'EmailUsageCode' attribute value.
     * 
     * @param emailUsageCode
     */
    public void setEmailUsageCode(String emailUsageCode) {
        this.emailUsageCode = emailUsageCode;
    }

    /** 
     * Get the 'FormatTypeCode' attribute value.
     * 
     * @return value
     */
    public String getFormatTypeCode() {
        return formatTypeCode;
    }

    /** 
     * Set the 'FormatTypeCode' attribute value.
     * 
     * @param formatTypeCode
     */
    public void setFormatTypeCode(String formatTypeCode) {
        this.formatTypeCode = formatTypeCode;
    }

    /** 
     * Get the 'EmailAddress' attribute value.
     * 
     * @return value
     */
    public String getEmailAddress() {
        return emailAddress;
    }

    /** 
     * Set the 'EmailAddress' attribute value.
     * 
     * @param emailAddress
     */
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /** 
     * Get the 'PurposeCode' attribute value. Identifies the Purpose Code
     * 
     * @return value
     */
    public String getPurposeCode() {
        return purposeCode;
    }

    /** 
     * Set the 'PurposeCode' attribute value. Identifies the Purpose Code
     * 
     * @param purposeCode
     */
    public void setPurposeCode(String purposeCode) {
        this.purposeCode = purposeCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'LanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getLanguageIDCode() {
        return languageIDCode;
    }

    /** 
     * Set the 'LanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @param languageIDCode
     */
    public void setLanguageIDCode(String languageIDCode) {
        this.languageIDCode = languageIDCode;
    }
}
