
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * *** SABRE ADDED *** Response for Template Search request
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchRSTemplateInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Message" minOccurs="0"/>
 *     &lt;xs:element type="ns:TemplateListElementType" name="TemplateList" minOccurs="0" maxOccurs="250"/>
 *     &lt;xs:element type="ns:TemplateType" name="Template" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchRSTemplateInfoType implements Serializable
{
    private String message;
    private List<TemplateListElementType> templateList = new ArrayList<TemplateListElementType>();
    private TemplateType template;

    /** 
     * Get the 'Message' element value. *** SABRE ADDED *** Search Specific Response Messages
     * 
     * @return value
     */
    public String getMessage() {
        return message;
    }

    /** 
     * Set the 'Message' element value. *** SABRE ADDED *** Search Specific Response Messages
     * 
     * @param message
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /** 
     * Get the list of 'TemplateList' element items. *** SABRE ADDED *** List of Template Ids upto 250
     * 
     * @return list
     */
    public List<TemplateListElementType> getTemplateList() {
        return templateList;
    }

    /** 
     * Set the list of 'TemplateList' element items. *** SABRE ADDED *** List of Template Ids upto 250
     * 
     * @param list
     */
    public void setTemplateList(List<TemplateListElementType> list) {
        templateList = list;
    }

    /** 
     * Get the 'Template' element value. *** SABRE ADDED *** Return Template only if there is an exact match 
     * 
     * @return value
     */
    public TemplateType getTemplate() {
        return template;
    }

    /** 
     * Set the 'Template' element value. *** SABRE ADDED *** Return Template only if there is an exact match 
     * 
     * @param template
     */
    public void setTemplate(TemplateType template) {
        this.template = template;
    }
}
