
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Search Individual Travel Agent
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchRSTravelAgentProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AgentNameType" name="AgentName" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSAgentInfoType" name="AgentInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSAddressType" name="Address" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSTelephoneType" name="Telephone" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSEmailType" name="Email" minOccurs="0"/>
 *     &lt;xs:element type="ns:PaymentFormType" name="PaymentForm" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSAssociatedProfilesType" name="AssociatedProfiles" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="ns:SearchRSRemarkType" name="Remark" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSCustomerReferenceInfoType" name="CustomerReferenceInfo" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSBusinessSystemIdentityInfoType" name="BusinessSystemIdentity" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchRSCustLoyaltyType" name="CustLoyalty" minOccurs="0"/>
 *     &lt;xs:element type="ns:AssociatedTemplateType" name="AssociatedTemplate" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchRSTravelAgentProfileType implements Serializable
{
    private AgentNameType agentName;
    private SearchRSAgentInfoType agentInfo;
    private SearchRSAddressType address;
    private SearchRSTelephoneType telephone;
    private SearchRSEmailType email;
    private PaymentFormType paymentForm;
    private List<SearchRSAssociatedProfilesType> associatedProfileList = new ArrayList<SearchRSAssociatedProfilesType>();
    private SearchRSRemarkType remark;
    private SearchRSCustomerReferenceInfoType customerReferenceInfo;
    private SearchRSBusinessSystemIdentityInfoType businessSystemIdentity;
    private SearchRSCustLoyaltyType custLoyalty;
    private AssociatedTemplateType associatedTemplate;

    /** 
     * Get the 'AgentName' element value. ***SABRE ADDED *** Agent Name Information 
     * 
     * @return value
     */
    public AgentNameType getAgentName() {
        return agentName;
    }

    /** 
     * Set the 'AgentName' element value. ***SABRE ADDED *** Agent Name Information 
     * 
     * @param agentName
     */
    public void setAgentName(AgentNameType agentName) {
        this.agentName = agentName;
    }

    /** 
     * Get the 'AgentInfo' element value. ***SABRE ADDED *** Agent Information 
     * 
     * @return value
     */
    public SearchRSAgentInfoType getAgentInfo() {
        return agentInfo;
    }

    /** 
     * Set the 'AgentInfo' element value. ***SABRE ADDED *** Agent Information 
     * 
     * @param agentInfo
     */
    public void setAgentInfo(SearchRSAgentInfoType agentInfo) {
        this.agentInfo = agentInfo;
    }

    /** 
     * Get the 'Address' element value. ***OTA Based *** Address Information 
     * 
     * @return value
     */
    public SearchRSAddressType getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value. ***OTA Based *** Address Information 
     * 
     * @param address
     */
    public void setAddress(SearchRSAddressType address) {
        this.address = address;
    }

    /** 
     * Get the 'Telephone' element value. ***OTA Based *** Telephone Information 
     * 
     * @return value
     */
    public SearchRSTelephoneType getTelephone() {
        return telephone;
    }

    /** 
     * Set the 'Telephone' element value. ***OTA Based *** Telephone Information 
     * 
     * @param telephone
     */
    public void setTelephone(SearchRSTelephoneType telephone) {
        this.telephone = telephone;
    }

    /** 
     * Get the 'Email' element value. ***OTA Based *** Email Information 
     * 
     * @return value
     */
    public SearchRSEmailType getEmail() {
        return email;
    }

    /** 
     * Set the 'Email' element value. ***OTA Based *** Email Information 
     * 
     * @param email
     */
    public void setEmail(SearchRSEmailType email) {
        this.email = email;
    }

    /** 
     * Get the 'PaymentForm' element value. ***OTA Based *** Payment Information 
     * 
     * @return value
     */
    public PaymentFormType getPaymentForm() {
        return paymentForm;
    }

    /** 
     * Set the 'PaymentForm' element value. ***OTA Based *** Payment Information 
     * 
     * @param paymentForm
     */
    public void setPaymentForm(PaymentFormType paymentForm) {
        this.paymentForm = paymentForm;
    }

    /** 
     * Get the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** Associated profiles
     * 
     * @return list
     */
    public List<SearchRSAssociatedProfilesType> getAssociatedProfileList() {
        return associatedProfileList;
    }

    /** 
     * Set the list of 'AssociatedProfiles' element items. *** SABRE ADDED *** Associated profiles
     * 
     * @param list
     */
    public void setAssociatedProfileList(
            List<SearchRSAssociatedProfilesType> list) {
        associatedProfileList = list;
    }

    /** 
     * Get the 'Remark' element value. *** SABRE ADDED *** Remarks of a profile
     * 
     * @return value
     */
    public SearchRSRemarkType getRemark() {
        return remark;
    }

    /** 
     * Set the 'Remark' element value. *** SABRE ADDED *** Remarks of a profile
     * 
     * @param remark
     */
    public void setRemark(SearchRSRemarkType remark) {
        this.remark = remark;
    }

    /** 
     * Get the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return value
     */
    public SearchRSCustomerReferenceInfoType getCustomerReferenceInfo() {
        return customerReferenceInfo;
    }

    /** 
     * Set the 'CustomerReferenceInfo' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param customerReferenceInfo
     */
    public void setCustomerReferenceInfo(
            SearchRSCustomerReferenceInfoType customerReferenceInfo) {
        this.customerReferenceInfo = customerReferenceInfo;
    }

    /** 
     * Get the 'BusinessSystemIdentity' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @return value
     */
    public SearchRSBusinessSystemIdentityInfoType getBusinessSystemIdentity() {
        return businessSystemIdentity;
    }

    /** 
     * Set the 'BusinessSystemIdentity' element value. *** SABRE ADDED *** Third party system Reference IDs for a profile
     * 
     * @param businessSystemIdentity
     */
    public void setBusinessSystemIdentity(
            SearchRSBusinessSystemIdentityInfoType businessSystemIdentity) {
        this.businessSystemIdentity = businessSystemIdentity;
    }

    /** 
     * Get the 'CustLoyalty' element value.
     * 
     * @return value
     */
    public SearchRSCustLoyaltyType getCustLoyalty() {
        return custLoyalty;
    }

    /** 
     * Set the 'CustLoyalty' element value.
     * 
     * @param custLoyalty
     */
    public void setCustLoyalty(SearchRSCustLoyaltyType custLoyalty) {
        this.custLoyalty = custLoyalty;
    }

    /** 
     * Get the 'AssociatedTemplate' element value.
     * 
     * @return value
     */
    public AssociatedTemplateType getAssociatedTemplate() {
        return associatedTemplate;
    }

    /** 
     * Set the 'AssociatedTemplate' element value.
     * 
     * @param associatedTemplate
     */
    public void setAssociatedTemplate(AssociatedTemplateType associatedTemplate) {
        this.associatedTemplate = associatedTemplate;
    }
}
