
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Added by Sabre
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SearchTPAIdentityType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:SearchRQLoginType" name="Login" minOccurs="0"/>
 *     &lt;xs:element type="ns:ProfileSubTypeType" name="ProfileSubType" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProfileTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ClientContextCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProfileName"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SearchTPAIdentityType implements Serializable
{
    private SearchRQLoginType login;
    private ProfileSubTypeType profileSubType;
    private String profileTypeCode;
    private String clientCode;
    private String clientContextCode;
    private String profileName;
    private String domainID;

    /** 
     * Get the 'Login' element value.
     * 
     * @return value
     */
    public SearchRQLoginType getLogin() {
        return login;
    }

    /** 
     * Set the 'Login' element value.
     * 
     * @param login
     */
    public void setLogin(SearchRQLoginType login) {
        this.login = login;
    }

    /** 
     * Get the 'ProfileSubType' element value.
     * 
     * @return value
     */
    public ProfileSubTypeType getProfileSubType() {
        return profileSubType;
    }

    /** 
     * Set the 'ProfileSubType' element value.
     * 
     * @param profileSubType
     */
    public void setProfileSubType(ProfileSubTypeType profileSubType) {
        this.profileSubType = profileSubType;
    }

    /** 
     * Get the 'ProfileTypeCode' attribute value.
     * 
     * @return value
     */
    public String getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value.
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(String profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'ProfileName' attribute value.
     * 
     * @return value
     */
    public String getProfileName() {
        return profileName;
    }

    /** 
     * Set the 'ProfileName' attribute value.
     * 
     * @param profileName
     */
    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }
}
