
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Used to move all data from one PCC to another
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StatusOfMoveDomainRSType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="MoveStatus"/>
 *     &lt;xs:element type="xs:string" name="Profile" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Template" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Metadata" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Validator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Filter" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Format" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="OriginDomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DestinationDomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StatusOfMoveDomainRSType implements Serializable
{
    private String moveStatus;
    private String profile;
    private String template;
    private String metadata;
    private String validator;
    private String filter;
    private String format;
    private String originDomainID;
    private String destinationDomainID;
    private String clientCode;
    private String clientContextCode;

    /** 
     * Get the 'MoveStatus' element value.
     * 
     * @return value
     */
    public String getMoveStatus() {
        return moveStatus;
    }

    /** 
     * Set the 'MoveStatus' element value.
     * 
     * @param moveStatus
     */
    public void setMoveStatus(String moveStatus) {
        this.moveStatus = moveStatus;
    }

    /** 
     * Get the 'Profile' element value.
     * 
     * @return value
     */
    public String getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value.
     * 
     * @param profile
     */
    public void setProfile(String profile) {
        this.profile = profile;
    }

    /** 
     * Get the 'Template' element value.
     * 
     * @return value
     */
    public String getTemplate() {
        return template;
    }

    /** 
     * Set the 'Template' element value.
     * 
     * @param template
     */
    public void setTemplate(String template) {
        this.template = template;
    }

    /** 
     * Get the 'Metadata' element value.
     * 
     * @return value
     */
    public String getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value.
     * 
     * @param metadata
     */
    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'Validator' element value.
     * 
     * @return value
     */
    public String getValidator() {
        return validator;
    }

    /** 
     * Set the 'Validator' element value.
     * 
     * @param validator
     */
    public void setValidator(String validator) {
        this.validator = validator;
    }

    /** 
     * Get the 'Filter' element value.
     * 
     * @return value
     */
    public String getFilter() {
        return filter;
    }

    /** 
     * Set the 'Filter' element value.
     * 
     * @param filter
     */
    public void setFilter(String filter) {
        this.filter = filter;
    }

    /** 
     * Get the 'Format' element value.
     * 
     * @return value
     */
    public String getFormat() {
        return format;
    }

    /** 
     * Set the 'Format' element value.
     * 
     * @param format
     */
    public void setFormat(String format) {
        this.format = format;
    }

    /** 
     * Get the 'OriginDomainID' attribute value. DomainID from which data will be moved
     * 
     * @return value
     */
    public String getOriginDomainID() {
        return originDomainID;
    }

    /** 
     * Set the 'OriginDomainID' attribute value. DomainID from which data will be moved
     * 
     * @param originDomainID
     */
    public void setOriginDomainID(String originDomainID) {
        this.originDomainID = originDomainID;
    }

    /** 
     * Get the 'DestinationDomainID' attribute value. DomainID to which data will be moved. Should be different from origin
     * 
     * @return value
     */
    public String getDestinationDomainID() {
        return destinationDomainID;
    }

    /** 
     * Set the 'DestinationDomainID' attribute value. DomainID to which data will be moved. Should be different from origin
     * 
     * @param destinationDomainID
     */
    public void setDestinationDomainID(String destinationDomainID) {
        this.destinationDomainID = destinationDomainID;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }
}
