
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_MarketingPreferenceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:NotificationPreferenceType" name="NotificationPreference" minOccurs="0" maxOccurs="10"/>
 *     &lt;xs:element type="ns:ConsentType" name="Consent" minOccurs="0" maxOccurs="10"/>
 *     &lt;xs:element type="ns:PsychographicCategoryType" name="PsychographicCategory" minOccurs="0" maxOccurs="50"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *     &lt;xs:element type="ns:DeclaredTravelHistoryPreferenceType" name="DeclaredTravelHistoryPreference" minOccurs="0" maxOccurs="200"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TPAMarketingPreferenceType implements Serializable
{
    private List<NotificationPreferenceType> notificationPreferenceList = new ArrayList<NotificationPreferenceType>();
    private List<ConsentType> consentList = new ArrayList<ConsentType>();
    private List<PsychographicCategoryType> psychographicCategoryList = new ArrayList<PsychographicCategoryType>();
    private TransactionalDataType transactionalData;
    private List<DeclaredTravelHistoryPreferenceType> declaredTravelHistoryPreferenceList = new ArrayList<DeclaredTravelHistoryPreferenceType>();

    /** 
     * Get the list of 'NotificationPreference' element items. *** SABRE ADDED *** Notification Prefereces for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @return list
     */
    public List<NotificationPreferenceType> getNotificationPreferenceList() {
        return notificationPreferenceList;
    }

    /** 
     * Set the list of 'NotificationPreference' element items. *** SABRE ADDED *** Notification Prefereces for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @param list
     */
    public void setNotificationPreferenceList(
            List<NotificationPreferenceType> list) {
        notificationPreferenceList = list;
    }

    /** 
     * Get the list of 'Consent' element items. *** SABRE ADDED *** Application Consents of a profile
     * 
     * @return list
     */
    public List<ConsentType> getConsentList() {
        return consentList;
    }

    /** 
     * Set the list of 'Consent' element items. *** SABRE ADDED *** Application Consents of a profile
     * 
     * @param list
     */
    public void setConsentList(List<ConsentType> list) {
        consentList = list;
    }

    /** 
     * Get the list of 'PsychographicCategory' element items. *** SABRE ADDED *** Stated Interests for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @return list
     */
    public List<PsychographicCategoryType> getPsychographicCategoryList() {
        return psychographicCategoryList;
    }

    /** 
     * Set the list of 'PsychographicCategory' element items. *** SABRE ADDED *** Stated Interests for a profile, Not applicable for Corporation and Agency Profile Types
     * 
     * @param list
     */
    public void setPsychographicCategoryList(
            List<PsychographicCategoryType> list) {
        psychographicCategoryList = list;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the list of 'DeclaredTravelHistoryPreference' element items.
     * 
     * @return list
     */
    public List<DeclaredTravelHistoryPreferenceType> getDeclaredTravelHistoryPreferenceList() {
        return declaredTravelHistoryPreferenceList;
    }

    /** 
     * Set the list of 'DeclaredTravelHistoryPreference' element items.
     * 
     * @param list
     */
    public void setDeclaredTravelHistoryPreferenceList(
            List<DeclaredTravelHistoryPreferenceType> list) {
        declaredTravelHistoryPreferenceList = list;
    }
}
