
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TelephoneType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:string" name="FullPhoneNumber"/>
 *       &lt;xs:element type="ns:ParsedPhoneNumberType" name="ParsedPhoneNumber"/>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ContactRemark" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LocationTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DeviceTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LanguageIDCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ServiceProvider"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DeviceVendor"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DeviceBrand"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DeviceModel"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PurposeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PhoneCityCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="ns:VIT_StarLineType" use="optional" name="VIT_LineType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_SecondaryQualifier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_OrderNmbr"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="FaxDevice"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="PNRTelephoneTagIndicator"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TelephoneType implements Serializable
{
    private int choiceSelect = -1;
    private static final int FULL_PHONE_NUMBER_CHOICE = 0;
    private static final int PARSED_PHONE_NUMBER_CHOICE = 1;
    private String fullPhoneNumber;
    private ParsedPhoneNumberType parsedPhoneNumber;
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String contactRemark;
    private String locationTypeCode;
    private String deviceTypeCode;
    private String languageIDCode;
    private String serviceProvider;
    private String deviceVendor;
    private String deviceBrand;
    private String deviceModel;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private String purposeCode;
    private String phoneCityCode;
    private String informationText;
    private VITStarLineType VITLineType;
    private String VITSecondaryQualifier;
    private String VITOrderNmbr;
    private YesNoType faxDevice;
    private YesNoType PNRTelephoneTagIndicator;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if FullPhoneNumber is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFullPhoneNumber() {
        return choiceSelect == FULL_PHONE_NUMBER_CHOICE;
    }

    /** 
     * Get the 'FullPhoneNumber' element value.
     * 
     * @return value
     */
    public String getFullPhoneNumber() {
        return fullPhoneNumber;
    }

    /** 
     * Set the 'FullPhoneNumber' element value.
     * 
     * @param fullPhoneNumber
     */
    public void setFullPhoneNumber(String fullPhoneNumber) {
        setChoiceSelect(FULL_PHONE_NUMBER_CHOICE);
        this.fullPhoneNumber = fullPhoneNumber;
    }

    /** 
     * Check if ParsedPhoneNumber is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifParsedPhoneNumber() {
        return choiceSelect == PARSED_PHONE_NUMBER_CHOICE;
    }

    /** 
     * Get the 'ParsedPhoneNumber' element value.
     * 
     * @return value
     */
    public ParsedPhoneNumberType getParsedPhoneNumber() {
        return parsedPhoneNumber;
    }

    /** 
     * Set the 'ParsedPhoneNumber' element value.
     * 
     * @param parsedPhoneNumber
     */
    public void setParsedPhoneNumber(ParsedPhoneNumberType parsedPhoneNumber) {
        setChoiceSelect(PARSED_PHONE_NUMBER_CHOICE);
        this.parsedPhoneNumber = parsedPhoneNumber;
    }

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'ContactRemark' element value. *** SABRE ADDED ***
    Additional information about the contact person.
     * 
     * @return value
     */
    public String getContactRemark() {
        return contactRemark;
    }

    /** 
     * Set the 'ContactRemark' element value. *** SABRE ADDED ***
    Additional information about the contact person.
     * 
     * @param contactRemark
     */
    public void setContactRemark(String contactRemark) {
        this.contactRemark = contactRemark;
    }

    /** 
     * Get the 'LocationTypeCode' attribute value. Refer to OTA Code List Phone Location Type (PLT).
    	
     * 
     * @return value
     */
    public String getLocationTypeCode() {
        return locationTypeCode;
    }

    /** 
     * Set the 'LocationTypeCode' attribute value. Refer to OTA Code List Phone Location Type (PLT).
    	
     * 
     * @param locationTypeCode
     */
    public void setLocationTypeCode(String locationTypeCode) {
        this.locationTypeCode = locationTypeCode;
    }

    /** 
     * Get the 'DeviceTypeCode' attribute value. Indicates type of technology associated with this telephone number, such as Voice, Data, Fax, Pager, Mobile, TTY, etc. Refer to OTA Code List Phone Technology Type (PTT).
     * 
     * @return value
     */
    public String getDeviceTypeCode() {
        return deviceTypeCode;
    }

    /** 
     * Set the 'DeviceTypeCode' attribute value. Indicates type of technology associated with this telephone number, such as Voice, Data, Fax, Pager, Mobile, TTY, etc. Refer to OTA Code List Phone Technology Type (PTT).
     * 
     * @param deviceTypeCode
     */
    public void setDeviceTypeCode(String deviceTypeCode) {
        this.deviceTypeCode = deviceTypeCode;
    }

    /** 
     * Get the 'LanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getLanguageIDCode() {
        return languageIDCode;
    }

    /** 
     * Set the 'LanguageIDCode' attribute value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @param languageIDCode
     */
    public void setLanguageIDCode(String languageIDCode) {
        this.languageIDCode = languageIDCode;
    }

    /** 
     * Get the 'ServiceProvider' attribute value. *** SABRE ADDED *** Service Provider  eg Sprint, TMobile etc 
     * 
     * @return value
     */
    public String getServiceProvider() {
        return serviceProvider;
    }

    /** 
     * Set the 'ServiceProvider' attribute value. *** SABRE ADDED *** Service Provider  eg Sprint, TMobile etc 
     * 
     * @param serviceProvider
     */
    public void setServiceProvider(String serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    /** 
     * Get the 'DeviceVendor' attribute value. *** SABRE ADDED ***Device Vendor like Samsung, Nokia etc
     * 
     * @return value
     */
    public String getDeviceVendor() {
        return deviceVendor;
    }

    /** 
     * Set the 'DeviceVendor' attribute value. *** SABRE ADDED ***Device Vendor like Samsung, Nokia etc
     * 
     * @param deviceVendor
     */
    public void setDeviceVendor(String deviceVendor) {
        this.deviceVendor = deviceVendor;
    }

    /** 
     * Get the 'DeviceBrand' attribute value. *** SABRE ADDED ***Device Brand like IPhone, Razar
     * 
     * @return value
     */
    public String getDeviceBrand() {
        return deviceBrand;
    }

    /** 
     * Set the 'DeviceBrand' attribute value. *** SABRE ADDED ***Device Brand like IPhone, Razar
     * 
     * @param deviceBrand
     */
    public void setDeviceBrand(String deviceBrand) {
        this.deviceBrand = deviceBrand;
    }

    /** 
     * Get the 'DeviceModel' attribute value. *** SABRE ADDED ***Device Model Number like V2, 580i etc
     * 
     * @return value
     */
    public String getDeviceModel() {
        return deviceModel;
    }

    /** 
     * Set the 'DeviceModel' attribute value. *** SABRE ADDED ***Device Model Number like V2, 580i etc
     * 
     * @param deviceModel
     */
    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'PurposeCode' attribute value. Identifies the Purpose Code
     * 
     * @return value
     */
    public String getPurposeCode() {
        return purposeCode;
    }

    /** 
     * Set the 'PurposeCode' attribute value. Identifies the Purpose Code
     * 
     * @param purposeCode
     */
    public void setPurposeCode(String purposeCode) {
        this.purposeCode = purposeCode;
    }

    /** 
     * Get the 'PhoneCityCode' attribute value. Used to store city code of the associated phone
     * 
     * @return value
     */
    public String getPhoneCityCode() {
        return phoneCityCode;
    }

    /** 
     * Set the 'PhoneCityCode' attribute value. Used to store city code of the associated phone
     * 
     * @param phoneCityCode
     */
    public void setPhoneCityCode(String phoneCityCode) {
        this.phoneCityCode = phoneCityCode;
    }

    /** 
     * Get the 'InformationText' attribute value. Used to store additional information
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Used to store additional information
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'VIT_LineType' attribute value.
     * 
     * @return value
     */
    public VITStarLineType getVITLineType() {
        return VITLineType;
    }

    /** 
     * Set the 'VIT_LineType' attribute value.
     * 
     * @param VITLineType
     */
    public void setVITLineType(VITStarLineType VITLineType) {
        this.VITLineType = VITLineType;
    }

    /** 
     * Get the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @return value
     */
    public String getVITSecondaryQualifier() {
        return VITSecondaryQualifier;
    }

    /** 
     * Set the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @param VITSecondaryQualifier
     */
    public void setVITSecondaryQualifier(String VITSecondaryQualifier) {
        this.VITSecondaryQualifier = VITSecondaryQualifier;
    }

    /** 
     * Get the 'VIT_OrderNmbr' attribute value.
     * 
     * @return value
     */
    public String getVITOrderNmbr() {
        return VITOrderNmbr;
    }

    /** 
     * Set the 'VIT_OrderNmbr' attribute value.
     * 
     * @param VITOrderNmbr
     */
    public void setVITOrderNmbr(String VITOrderNmbr) {
        this.VITOrderNmbr = VITOrderNmbr;
    }

    /** 
     * Get the 'FaxDevice' attribute value. Indictes if telephone can work as fax machine
     * 
     * @return value
     */
    public YesNoType getFaxDevice() {
        return faxDevice;
    }

    /** 
     * Set the 'FaxDevice' attribute value. Indictes if telephone can work as fax machine
     * 
     * @param faxDevice
     */
    public void setFaxDevice(YesNoType faxDevice) {
        this.faxDevice = faxDevice;
    }

    /** 
     * Get the 'PNRTelephoneTagIndicator' attribute value. Indicates if user wants to include phone tag in filter
     * 
     * @return value
     */
    public YesNoType getPNRTelephoneTagIndicator() {
        return PNRTelephoneTagIndicator;
    }

    /** 
     * Set the 'PNRTelephoneTagIndicator' attribute value. Indicates if user wants to include phone tag in filter
     * 
     * @param PNRTelephoneTagIndicator
     */
    public void setPNRTelephoneTagIndicator(YesNoType PNRTelephoneTagIndicator) {
        this.PNRTelephoneTagIndicator = PNRTelephoneTagIndicator;
    }
}
