
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Root element for Format content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TemplateAssociatedFormatsType">
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="FormatID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FormatName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SequenceNo"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="CreateDateTime"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="UpdateDateTime"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TemplateAssociatedFormatsType implements Serializable
{
    private String domainID;
    private String formatID;
    private String formatName;
    private String displaySequenceNo;
    private String sequenceNo;
    private Date createDateTime;
    private Date updateDateTime;

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'FormatID' attribute value.
     * 
     * @return value
     */
    public String getFormatID() {
        return formatID;
    }

    /** 
     * Set the 'FormatID' attribute value.
     * 
     * @param formatID
     */
    public void setFormatID(String formatID) {
        this.formatID = formatID;
    }

    /** 
     * Get the 'FormatName' attribute value.
     * 
     * @return value
     */
    public String getFormatName() {
        return formatName;
    }

    /** 
     * Set the 'FormatName' attribute value.
     * 
     * @param formatName
     */
    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'SequenceNo' attribute value. This attribute should be used as OrderSequenceNo, different name is for schema backward compatibility
     * 
     * @return value
     */
    public String getSequenceNo() {
        return sequenceNo;
    }

    /** 
     * Set the 'SequenceNo' attribute value. This attribute should be used as OrderSequenceNo, different name is for schema backward compatibility
     * 
     * @param sequenceNo
     */
    public void setSequenceNo(String sequenceNo) {
        this.sequenceNo = sequenceNo;
    }

    /** 
     * Get the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @return value
     */
    public Date getCreateDateTime() {
        return createDateTime;
    }

    /** 
     * Set the 'CreateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @param createDateTime
     */
    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    /** 
     * Get the 'UpdateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @return value
     */
    public Date getUpdateDateTime() {
        return updateDateTime;
    }

    /** 
     * Set the 'UpdateDateTime' attribute value. *** SABRE ADDED ***
     * 
     * @param updateDateTime
     */
    public void setUpdateDateTime(Date updateDateTime) {
        this.updateDateTime = updateDateTime;
    }
}
