
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Contains basic data on the customer's identity, location, relationships, finances, memberships, etc.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TemplateCustomerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PersonNameType" name="PersonName" minOccurs="0" maxOccurs="25"/>
 *     &lt;xs:element type="ns:TelephoneType" name="Telephone" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:EmailType" name="Email" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:AddressType" name="Address" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:PaymentFormType" name="PaymentForm" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:RelatedIndividualType" name="RelatedIndividual" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:ContactType" name="EmergencyContactPerson" minOccurs="0" maxOccurs="10"/>
 *     &lt;xs:element type="ns:DocumentType" name="Document" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:CustLoyaltyType" name="CustLoyalty" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:EmploymentInfoType" name="EmploymentInfo" minOccurs="0" maxOccurs="50"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:date" use="optional" name="BirthDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MaritalStatusCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GenderCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgeRange"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RedressNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="KnownTravelerNumber"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="ChildIndicator"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="SeniorIndicator"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="LapInfantIndicator"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="IsSubjectToSecureFlightRule"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TemplateCustomerType implements Serializable
{
    private List<PersonNameType> personNameList = new ArrayList<PersonNameType>();
    private List<TelephoneType> telephoneList = new ArrayList<TelephoneType>();
    private List<EmailType> emailList = new ArrayList<EmailType>();
    private List<AddressType> addressList = new ArrayList<AddressType>();
    private List<PaymentFormType> paymentFormList = new ArrayList<PaymentFormType>();
    private List<RelatedIndividualType> relatedIndividualList = new ArrayList<RelatedIndividualType>();
    private List<ContactType> emergencyContactPersonList = new ArrayList<ContactType>();
    private List<DocumentType> documentList = new ArrayList<DocumentType>();
    private List<CustLoyaltyType> custLoyaltyList = new ArrayList<CustLoyaltyType>();
    private List<EmploymentInfoType> employmentInfoList = new ArrayList<EmploymentInfoType>();
    private Date birthDate;
    private String maritalStatusCode;
    private String genderCode;
    private String ageRange;
    private String redressNumber;
    private String knownTravelerNumber;
    private YesNoType childIndicator;
    private YesNoType seniorIndicator;
    private YesNoType lapInfantIndicator;
    private YesNoType isSubjectToSecureFlightRule;

    /** 
     * Get the list of 'PersonName' element items. ***OTA Based *** Person Name Information 
     * 
     * @return list
     */
    public List<PersonNameType> getPersonNameList() {
        return personNameList;
    }

    /** 
     * Set the list of 'PersonName' element items. ***OTA Based *** Person Name Information 
     * 
     * @param list
     */
    public void setPersonNameList(List<PersonNameType> list) {
        personNameList = list;
    }

    /** 
     * Get the list of 'Telephone' element items. ***OTA Based *** Telephone Information 
     * 
     * @return list
     */
    public List<TelephoneType> getTelephoneList() {
        return telephoneList;
    }

    /** 
     * Set the list of 'Telephone' element items. ***OTA Based *** Telephone Information 
     * 
     * @param list
     */
    public void setTelephoneList(List<TelephoneType> list) {
        telephoneList = list;
    }

    /** 
     * Get the list of 'Email' element items. ***OTA Based *** Email Information 
     * 
     * @return list
     */
    public List<EmailType> getEmailList() {
        return emailList;
    }

    /** 
     * Set the list of 'Email' element items. ***OTA Based *** Email Information 
     * 
     * @param list
     */
    public void setEmailList(List<EmailType> list) {
        emailList = list;
    }

    /** 
     * Get the list of 'Address' element items. ***OTA Based *** Address Information 
     * 
     * @return list
     */
    public List<AddressType> getAddressList() {
        return addressList;
    }

    /** 
     * Set the list of 'Address' element items. ***OTA Based *** Address Information 
     * 
     * @param list
     */
    public void setAddressList(List<AddressType> list) {
        addressList = list;
    }

    /** 
     * Get the list of 'PaymentForm' element items. ***OTA Based *** Payment Information 
     * 
     * @return list
     */
    public List<PaymentFormType> getPaymentFormList() {
        return paymentFormList;
    }

    /** 
     * Set the list of 'PaymentForm' element items. ***OTA Based *** Payment Information 
     * 
     * @param list
     */
    public void setPaymentFormList(List<PaymentFormType> list) {
        paymentFormList = list;
    }

    /** 
     * Get the list of 'RelatedIndividual' element items. ***OTA Based *** Related Traveler Information 
     * 
     * @return list
     */
    public List<RelatedIndividualType> getRelatedIndividualList() {
        return relatedIndividualList;
    }

    /** 
     * Set the list of 'RelatedIndividual' element items. ***OTA Based *** Related Traveler Information 
     * 
     * @param list
     */
    public void setRelatedIndividualList(List<RelatedIndividualType> list) {
        relatedIndividualList = list;
    }

    /** 
     * Get the list of 'EmergencyContactPerson' element items. ***OTA Based *** Emergency Contact Person Information 
     * 
     * @return list
     */
    public List<ContactType> getEmergencyContactPersonList() {
        return emergencyContactPersonList;
    }

    /** 
     * Set the list of 'EmergencyContactPerson' element items. ***OTA Based *** Emergency Contact Person Information 
     * 
     * @param list
     */
    public void setEmergencyContactPersonList(List<ContactType> list) {
        emergencyContactPersonList = list;
    }

    /** 
     * Get the list of 'Document' element items. ***OTA Based *** Document Information 
     * 
     * @return list
     */
    public List<DocumentType> getDocumentList() {
        return documentList;
    }

    /** 
     * Set the list of 'Document' element items. ***OTA Based *** Document Information 
     * 
     * @param list
     */
    public void setDocumentList(List<DocumentType> list) {
        documentList = list;
    }

    /** 
     * Get the list of 'CustLoyalty' element items. ***OTA Based *** Customer Loyalty (Frequent Flyer, Prefered Vendor etc.) Information 
     * 
     * @return list
     */
    public List<CustLoyaltyType> getCustLoyaltyList() {
        return custLoyaltyList;
    }

    /** 
     * Set the list of 'CustLoyalty' element items. ***OTA Based *** Customer Loyalty (Frequent Flyer, Prefered Vendor etc.) Information 
     * 
     * @param list
     */
    public void setCustLoyaltyList(List<CustLoyaltyType> list) {
        custLoyaltyList = list;
    }

    /** 
     * Get the list of 'EmploymentInfo' element items. *** Sabre Added *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @return list
     */
    public List<EmploymentInfoType> getEmploymentInfoList() {
        return employmentInfoList;
    }

    /** 
     * Set the list of 'EmploymentInfo' element items. *** Sabre Added *** EmploymentInfo elements and attributes, per Trading Partner Agreement (TPA)							
     * 
     * @param list
     */
    public void setEmploymentInfoList(List<EmploymentInfoType> list) {
        employmentInfoList = list;
    }

    /** 
     * Get the 'BirthDate' attribute value. Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
     * 
     * @return value
     */
    public Date getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'BirthDate' attribute value. Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
     * 
     * @param birthDate
     */
    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'MaritalStatusCode' attribute value. ***SABRE ADDED*** Marital status of a person
     * 
     * @return value
     */
    public String getMaritalStatusCode() {
        return maritalStatusCode;
    }

    /** 
     * Set the 'MaritalStatusCode' attribute value. ***SABRE ADDED*** Marital status of a person
     * 
     * @param maritalStatusCode
     */
    public void setMaritalStatusCode(String maritalStatusCode) {
        this.maritalStatusCode = maritalStatusCode;
    }

    /** 
     * Get the 'GenderCode' attribute value.
     * 
     * @return value
     */
    public String getGenderCode() {
        return genderCode;
    }

    /** 
     * Set the 'GenderCode' attribute value.
     * 
     * @param genderCode
     */
    public void setGenderCode(String genderCode) {
        this.genderCode = genderCode;
    }

    /** 
     * Get the 'AgeRange' attribute value. ***SABRE ADDED*** Age Range of a person customizable by a client
     * 
     * @return value
     */
    public String getAgeRange() {
        return ageRange;
    }

    /** 
     * Set the 'AgeRange' attribute value. ***SABRE ADDED*** Age Range of a person customizable by a client
     * 
     * @param ageRange
     */
    public void setAgeRange(String ageRange) {
        this.ageRange = ageRange;
    }

    /** 
     * Get the 'RedressNumber' attribute value.
     * 
     * @return value
     */
    public String getRedressNumber() {
        return redressNumber;
    }

    /** 
     * Set the 'RedressNumber' attribute value.
     * 
     * @param redressNumber
     */
    public void setRedressNumber(String redressNumber) {
        this.redressNumber = redressNumber;
    }

    /** 
     * Get the 'KnownTravelerNumber' attribute value.
     * 
     * @return value
     */
    public String getKnownTravelerNumber() {
        return knownTravelerNumber;
    }

    /** 
     * Set the 'KnownTravelerNumber' attribute value.
     * 
     * @param knownTravelerNumber
     */
    public void setKnownTravelerNumber(String knownTravelerNumber) {
        this.knownTravelerNumber = knownTravelerNumber;
    }

    /** 
     * Get the 'ChildIndicator' attribute value.
     * 
     * @return value
     */
    public YesNoType getChildIndicator() {
        return childIndicator;
    }

    /** 
     * Set the 'ChildIndicator' attribute value.
     * 
     * @param childIndicator
     */
    public void setChildIndicator(YesNoType childIndicator) {
        this.childIndicator = childIndicator;
    }

    /** 
     * Get the 'SeniorIndicator' attribute value.
     * 
     * @return value
     */
    public YesNoType getSeniorIndicator() {
        return seniorIndicator;
    }

    /** 
     * Set the 'SeniorIndicator' attribute value.
     * 
     * @param seniorIndicator
     */
    public void setSeniorIndicator(YesNoType seniorIndicator) {
        this.seniorIndicator = seniorIndicator;
    }

    /** 
     * Get the 'LapInfantIndicator' attribute value.
     * 
     * @return value
     */
    public YesNoType getLapInfantIndicator() {
        return lapInfantIndicator;
    }

    /** 
     * Set the 'LapInfantIndicator' attribute value.
     * 
     * @param lapInfantIndicator
     */
    public void setLapInfantIndicator(YesNoType lapInfantIndicator) {
        this.lapInfantIndicator = lapInfantIndicator;
    }

    /** 
     * Get the 'IsSubjectToSecureFlightRule' attribute value.
     * 
     * @return value
     */
    public YesNoType getIsSubjectToSecureFlightRule() {
        return isSubjectToSecureFlightRule;
    }

    /** 
     * Set the 'IsSubjectToSecureFlightRule' attribute value.
     * 
     * @param isSubjectToSecureFlightRule
     */
    public void setIsSubjectToSecureFlightRule(
            YesNoType isSubjectToSecureFlightRule) {
        this.isSubjectToSecureFlightRule = isSubjectToSecureFlightRule;
    }
}
