
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * An element of a profile list
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TemplateListElementType">
 *   &lt;xs:attribute type="xs:string" use="required" name="TemplateID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="TemplateName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TemplateDescription"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *   &lt;xs:attribute type="ns:StatusType" use="required" name="TemplateStatusCode"/>
 *   &lt;xs:attribute type="ns:ProfileTypeInfo" use="required" name="TemplateTypeCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TemplateListElementType implements Serializable
{
    private String templateID;
    private String domainID;
    private String templateName;
    private String templateDescription;
    private String clientCode;
    private String clientContextCode;
    private StatusType templateStatusCode;
    private ProfileTypeInfo templateTypeCode;

    /** 
     * Get the 'TemplateID' attribute value.
     * 
     * @return value
     */
    public String getTemplateID() {
        return templateID;
    }

    /** 
     * Set the 'TemplateID' attribute value.
     * 
     * @param templateID
     */
    public void setTemplateID(String templateID) {
        this.templateID = templateID;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'TemplateName' attribute value.
     * 
     * @return value
     */
    public String getTemplateName() {
        return templateName;
    }

    /** 
     * Set the 'TemplateName' attribute value.
     * 
     * @param templateName
     */
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    /** 
     * Get the 'TemplateDescription' attribute value.
     * 
     * @return value
     */
    public String getTemplateDescription() {
        return templateDescription;
    }

    /** 
     * Set the 'TemplateDescription' attribute value.
     * 
     * @param templateDescription
     */
    public void setTemplateDescription(String templateDescription) {
        this.templateDescription = templateDescription;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'TemplateStatusCode' attribute value.
     * 
     * @return value
     */
    public StatusType getTemplateStatusCode() {
        return templateStatusCode;
    }

    /** 
     * Set the 'TemplateStatusCode' attribute value.
     * 
     * @param templateStatusCode
     */
    public void setTemplateStatusCode(StatusType templateStatusCode) {
        this.templateStatusCode = templateStatusCode;
    }

    /** 
     * Get the 'TemplateTypeCode' attribute value.
     * 
     * @return value
     */
    public ProfileTypeInfo getTemplateTypeCode() {
        return templateTypeCode;
    }

    /** 
     * Set the 'TemplateTypeCode' attribute value.
     * 
     * @param templateTypeCode
     */
    public void setTemplateTypeCode(ProfileTypeInfo templateTypeCode) {
        this.templateTypeCode = templateTypeCode;
    }
}
