
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TemplateSearchCriteriaType">
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="TemplateName"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="TemplateTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ClientContextCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PageNumber"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="ReturnCount"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TemplateSearchCriteriaType implements Serializable
{
    private String domainID;
    private String templateName;
    private String templateTypeCode;
    private String clientCode;
    private String clientContextCode;
    private String pageNumber;
    private BigInteger returnCount;

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'TemplateName' attribute value.
     * 
     * @return value
     */
    public String getTemplateName() {
        return templateName;
    }

    /** 
     * Set the 'TemplateName' attribute value.
     * 
     * @param templateName
     */
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    /** 
     * Get the 'TemplateTypeCode' attribute value.
     * 
     * @return value
     */
    public String getTemplateTypeCode() {
        return templateTypeCode;
    }

    /** 
     * Set the 'TemplateTypeCode' attribute value.
     * 
     * @param templateTypeCode
     */
    public void setTemplateTypeCode(String templateTypeCode) {
        this.templateTypeCode = templateTypeCode;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'PageNumber' attribute value. 
     *** SABRE ADDED *** Needed for repetitive search, if
    				not populated then it is considered first search
    			
     * 
     * @return value
     */
    public String getPageNumber() {
        return pageNumber;
    }

    /** 
     * Set the 'PageNumber' attribute value. 
     *** SABRE ADDED *** Needed for repetitive search, if
    				not populated then it is considered first search
    			
     * 
     * @param pageNumber
     */
    public void setPageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
    }

    /** 
     * Get the 'ReturnCount' attribute value. 
     *** SABRE ADDED *** Profiles to be returned in
    				response, if not populated then we will return
    				default count
    			
     * 
     * @return value
     */
    public BigInteger getReturnCount() {
        return returnCount;
    }

    /** 
     * Set the 'ReturnCount' attribute value. 
     *** SABRE ADDED *** Profiles to be returned in
    				response, if not populated then we will return
    				default count
    			
     * 
     * @param returnCount
     */
    public void setReturnCount(BigInteger returnCount) {
        this.returnCount = returnCount;
    }
}
